package clinical.web.actions;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.cache.CacheUtils;
import clinical.server.vo.Extendedtuple;
import clinical.server.vo.Tuplecolumns;
import clinical.server.vo.Tuplevarchar;
import clinical.utils.Assertion;
import clinical.web.Constants;
import clinical.web.IAnalysisResultService;
import clinical.web.ServiceFactory;
import clinical.web.common.UserInfo;
import clinical.web.common.vo.AnalysisExTupleInfo;
import clinical.web.forms.AsQueryBuilderForm;
import clinical.web.vo.AnalysisResultQueryInfo;
import clinical.web.vo.QueryInfo;

/**
 * @author I. Burak Ozyurt
 * @version $Id: AnalysisResultQueryAction.java,v 1.1.2.1 2008/06/06 23:32:06
 *          bozyurt Exp $
 */
public class AnalysisResultQueryAction extends BaseLookupDispatchAction {
   private Map<String, String> map = new HashMap<String, String>(5);
   private Log log = LogFactory.getLog(AnalysisResultQueryAction.class);

   protected Map<String, String> getKeyMethodMap() {
      map.put("button.asq.show", "show");
      map.put("action.asq.query", "query");
      map.put("action.asq.msquery", "multiSiteQuery");
      return map;
   }

   public ActionForward show(ActionMapping mapping, ActionForm form,
         HttpServletRequest request, HttpServletResponse response)
         throws Exception {
      IAnalysisResultService ars = null;
      log.info("in show");
      try {
         UserInfo ui = getUserInfo(request);
         HttpSession session = request.getSession(false);
         String dbID = (String) session
               .getAttribute(Constants.SESSION_DBID_KEY);
         AsQueryBuilderForm aqbForm = (AsQueryBuilderForm) form;

         log.info("caQueryString: " + aqbForm.getCaQueryString());

         ars = ServiceFactory.getAnalysisResultService(dbID);
         Map<String, AnalysisExTupleInfo> anETIMap = ars
               .getExTuplesPerAnalysisAvail(ui);

         AnalysisResultQueryInfo arqi = new AnalysisResultQueryInfo();
         arqi.setAnETIMap(anETIMap);

         Set<String> exTupleNamesSet = new HashSet<String>(17);
         Map<BigDecimal, Extendedtuple> etMap = new HashMap<BigDecimal, Extendedtuple>(
               17);
         for (AnalysisExTupleInfo aeit : anETIMap.values()) {
            for (Extendedtuple et : aeit.getExTupleSet()) {
               exTupleNamesSet.add(et.getName());
               etMap.put(et.getUniqueid(), et);
            }
         }

         List<Tuplecolumns> tcList = ars.getTupleColumnsForET(ui,
               new ArrayList<String>(exTupleNamesSet));

         Map<Integer, List<Tuplecolumns>> extTupleColsMap = new HashMap<Integer, List<Tuplecolumns>>();
         for (Tuplecolumns tc : tcList) {
            Integer etID = tc.getExtendedtupleid().intValue();
            List<Tuplecolumns> tceList = extTupleColsMap.get(etID);
            if (tceList == null) {
               tceList = new ArrayList<Tuplecolumns>(20);
               extTupleColsMap.put(etID, tceList);
            }
            tceList.add(tc);
         }
         arqi.setExtTupleColsMap(extTupleColsMap);

         List<Integer> extTupleIDList = new ArrayList<Integer>(etMap.size());
         for (BigDecimal id : etMap.keySet()) {
            extTupleIDList.add(id.intValue());
         }

         // FIXME: if the master site does not have any analysis results it has
         // to get the anatomical entities from a remote site with anatomical
         // entity data
         List<Tuplevarchar> tvList = ars.getMeasurementGroupNamesForET(ui,
               "anatomicalEntity", extTupleIDList);

         Map<Integer, List<String>> extTuple2MeasGroupNameMap = new HashMap<Integer, List<String>>();
         for (Tuplevarchar tv : tvList) {
            Integer etID = tv.getExtendedtupleid().intValue();
            List<String> mgNameList = extTuple2MeasGroupNameMap.get(etID);
            if (mgNameList == null) {
               mgNameList = new ArrayList<String>();
               extTuple2MeasGroupNameMap.put(etID, mgNameList);
            }
            mgNameList.add(tv.getTextvalue());
         }
         arqi.setExtTuple2MeasGroupNameMap(extTuple2MeasGroupNameMap);
         QueryInfo qi = aqbForm.getQueryInfo();
         if (qi == null) {
            qi = new QueryInfo(arqi);
            aqbForm.setQueryInfo(qi);
         }
         qi.setArqi(arqi);

         // System.out.println(arqi.getAsJSON());
         return mapping.findForward(Constants.SUCCESS);
      } catch (Exception x) {
         return processExceptions(request, response, mapping, form, x);
      }
   }

   public ActionForward query(ActionMapping mapping, ActionForm form,
         HttpServletRequest request, HttpServletResponse response)
         throws Exception {
      AsQueryBuilderForm queryForm = null;
      try {
         log.info("query");
         UserInfo ui = getUserInfo(request);
         String queryString = request.getParameter("queryString");
         Assertion.assertNotNull(queryString);
         log.info("queryString:" + queryString);
         HttpSession session = request.getSession(false);
         String dbID = (String) session
               .getAttribute(Constants.SESSION_DBID_KEY);
         Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();
         String primarySiteID = dbID2SiteIDMap.get(dbID);

         queryForm = (AsQueryBuilderForm) form;

         QueryAggregator qa = new QueryAggregator(dbID, ui, queryForm);

         qa.handleQuery(queryForm.getCaQueryString(), queryString,
               primarySiteID);

         return mapping.findForward(Constants.FORWARD_RESULTS);
      } catch (Exception x) {
         return processExceptions(request, response, mapping, form, x);
      } finally {
         // clean state for next query
         if (queryForm != null) {
            queryForm.setDdQueryString(null);
            queryForm.setCaQueryString(null);
         }
      }
   }

   public ActionForward multiSiteQuery(ActionMapping mapping, ActionForm form,
         HttpServletRequest request, HttpServletResponse response)
         throws Exception {
      AsQueryBuilderForm queryForm = null;
      try {
         log.info("multiSiteQuery");
         UserInfo ui = getUserInfo(request);
         String queryString = request.getParameter("queryString");
         Assertion.assertNotNull(queryString);
         log.info("queryString:" + queryString);
         HttpSession session = request.getSession(false);
         String dbID = (String) session
               .getAttribute(Constants.SESSION_DBID_KEY);
         Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();
         String primarySiteID = dbID2SiteIDMap.get(dbID);

         queryForm = (AsQueryBuilderForm) form;

         QueryAggregator qa = new QueryAggregator(dbID, ui, queryForm);

         qa.handleMultisiteQuery(queryForm.getCaQueryString(), queryString,
               primarySiteID);

         return mapping.findForward(Constants.FORWARD_RESULTS);
      } catch (Exception x) {
         return processExceptions(request, response, mapping, form, x);
      } finally {
         // clean state for next query
         if (queryForm != null) {
            queryForm.setDdQueryString(null);
            queryForm.setCaQueryString(null);
         }
      }
   }
}
