package clinical.web.actions;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.utils.HTTPUtils;
import clinical.web.Constants;
import clinical.web.ServiceFactory;
import clinical.web.SessionStateCoordinator;
import clinical.web.UserContainer;
import clinical.web.common.IAuthenticationService;
import clinical.web.common.UserInfo;
import clinical.web.forms.LoginHandlerForm;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: AutoLoginAction.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class AutoLoginAction extends BaseAction {
  private Log log = LogFactory.getLog(AutoLoginAction.class);

  public AutoLoginAction() {
  }

  public ActionForward execute(ActionMapping mapping,
                               ActionForm form,
                               HttpServletRequest request,
                               HttpServletResponse response) throws Exception
  {

    IAuthenticationService authService = ServiceFactory.getAuthenticationService();
    LoginHandlerForm lhForm = (LoginHandlerForm) form;

    String userName = lhForm.getUsername();
    String pwd = lhForm.getPassword();
    String dbID = lhForm.getDbID();

    // log.info("userName="+ userName + ",pwd=" + pwd + ",dbID=" + dbID);
    if (dbID == null) {
      dbID = ServiceFactory.getSecurityService().getDefaultDBID();
      log.info("The database id selected:"+ dbID);
    }

    UserInfo ui = null;
    if (log.isDebugEnabled())
      log.debug("authenticating the user " + userName);
    try {
      ui = authService.authenticate(userName, pwd, dbID);
      if (log.isDebugEnabled())
        log.debug("The user " + userName + " is authenticated!");

      HttpSession session = request.getSession(false);
      if (session != null)
        session.invalidate();
        // create a new session
      session = request.getSession(true);
      UserContainer userCon = new UserContainer(ui, dbID);

      session.setAttribute(Constants.CONTAINER_KEY, userCon);

      session.setAttribute( Constants.SESSION_DBID_KEY, dbID);

      // precache the assessment info
      /*
      IAssessmentService asService = ServiceFactory.getAssessmentService(dbID);
      List<Assessment> assessments = asService.getAllAssessments(ui);
      AsQueryBuilderForm queryForm = new AsQueryBuilderForm();
      session.setAttribute(Constants.ASQUERYFORM_KEY, queryForm);

      Map<String, String> assessmentNameMap = new HashMap<String, String>(31);


      for (Assessment as : assessments) {
        AssessmentSelectionInfo asi = new AssessmentSelectionInfo();
        asi.setAssessmentID(as.getAssessmentid());
        asi.setDescription(as.getDescription());
        asi.setName(as.getName());
        queryForm.addAssessment(asi);
        assessmentNameMap.put(as.getName(), as.getName());
      }

      session.setAttribute(Constants.ASSESSMENT_NAME_MAP, assessmentNameMap);

      // prepare the stored query summaries for this user
      QueryWizardHelper.prepareStoredQueryDescriptions(ui, asService, ui.getName(), queryForm);
*/
      // set the session state coordinator to control menu items and/or
      // buttons based on the current state
      SessionStateCoordinator ssc = new SessionStateCoordinator(dbID);
      session.setAttribute( Constants.SESSION_STATE_COORDINATOR_KEY, ssc);

      if ( log.isDebugEnabled() ) {
        String contents = HTTPUtils.dumpSessionContents(session);
        log.debug(contents);
      }

    } catch (Exception x) {
      log.debug("processing exception "+ x);
      return processExceptions(request, response, mapping, form, x);
    }

    return mapping.findForward(Constants.SUCCESS);
  }

}