package clinical.web.actions;

import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.json.JSONObject;

import clinical.utils.FileUtils;
import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.web.common.UserInfo;
import clinical.web.forms.CBFROIForm;
import clinical.web.forms.JobManForm;
import clinical.web.scheduler.JobRecord;
import clinical.web.scheduler.JobScheduler;
import clinical.web.workflow.cbf.CBFWFContext;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: CBFROIAction.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class CBFROIAction extends BaseLookupDispatchAction {
	private Map<String, String> map = new HashMap<String, String>(11);
	static Pattern fileNumberPattern = Pattern.compile("(\\d+)$");
	private Log log = LogFactory.getLog(CBFROIAction.class);

	protected Map<String, String> getKeyMethodMap() {
		map.put("action.cbfroi.view", "viewMain");
		map.put("action.cbfroi.resume", "resumeJob");
		map.put("action.cbfroi.get.images", "getImages");
		map.put("action.cbfroi.send.mask", "sendMask");
		map.put("action.cbfroi.send.masks", "sendMasks");

		return map;
	}

	public ActionForward viewMain(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> viewMain");
		try {
			getUserInfo(request);
			CBFROIForm roiForm = (CBFROIForm) form;
			// for TEST
			// FileUtils.save2File(session.getId(), new File(System
			// .getProperty("user.home"), "sessionid.txt")
			// .getAbsolutePath());

			String jobID = request.getParameter("jobID");
			System.out.println("jobID:" + jobID);

			roiForm.setJobID(jobID);
			// TODO
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("viewMain", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward getImages(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> getImages");
		try {
			UserInfo ui = getUserInfo(request);
			CBFROIForm roiForm = (CBFROIForm) form;
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			String jobID = roiForm.getJobID();

			JobScheduler scheduler = JobScheduler.getInstance();

			JobRecord jr = scheduler.getJobRecord(ui, dbID, ui
					.getPerceivedName(), jobID);

			String ctxAsJSON = jr.getContext();
			System.out.println("ctxAsJSON:" + ctxAsJSON);

			JSONObject json = new JSONObject(ctxAsJSON);
			CBFWFContext ctx = CBFWFContext.fromJSON(json);

			roiForm.setContext(ctx);

			String cacheDir = roiForm.getContext().getCacheDir();
			File matlabOutDir = new File(cacheDir, "matlab_out");

			// String webRootPath = session.getServletContext().getRealPath(
			// "/pages/");
			String webRootPath = session.getServletContext().getRealPath("/");
			System.out.println("webRootPath:" + webRootPath);
			String imageDirName = jobID + "_" + ui.getPerceivedName();
			File imgDir = new File(webRootPath, imageDirName);
			imgDir.mkdir();
			List<String> relImgPaths = new ArrayList<String>();

			// TODO copy images to the imgDir;
			System.out.println("Image reader format names");
			for (String s : ImageIO.getReaderFormatNames()) {
				System.out.println(s);
			}

			if (matlabOutDir.isDirectory()) {
				File[] files = matlabOutDir.listFiles();
				List<File> imgFiles = new ArrayList<File>();
                assert files != null;
                for (File f : files) {
					String fname = f.getName();
					if (fname.toLowerCase().endsWith(".tif")
							|| fname.endsWith(".png")
							|| fname.endsWith(".jpeg")) {

						File destImg = new File(imgDir, fname);
						if (fname.toLowerCase().endsWith(".tif")
								&& ImageIO.getImageReadersBySuffix("tif")
										.hasNext()) {
							fname = fname.replaceFirst("\\.\\w+$", ".png");
							destImg = new File(imgDir, fname);
							BufferedImage tif = ImageIO.read(f);
							System.out.println("reading from :" + f);
							System.out.println("tif:" + tif);
							System.out.println("writing to " + destImg);
							ImageIO.write(tif, "png", destImg);
						} else {
							FileUtils.copyFile(f.getAbsolutePath(), destImg
									.getAbsolutePath());
						}
						imgFiles.add(destImg);
					}
				}
				Collections.sort(imgFiles, new Comparator<File>() {
					public int compare(File o1, File o2) {
						int fn1 = getFileNumber(o1.getName());
						int fn2 = getFileNumber(o2.getName());

						return fn1 - fn2;
					}
				});
				for (File f : imgFiles) {
					relImgPaths.add(imageDirName + "/" + f.getName());
				}

			} else {
				// TEST
				File srcImg = new File(webRootPath, "brain.png");
				FileUtils.copyFile(srcImg.getAbsolutePath(), new File(imgDir,
						srcImg.getName()).getAbsolutePath());

				for (int i = 0; i < 23; i++) {
					String relPath = imageDirName + "/brain.png";
					relImgPaths.add(relPath);
				}
			}

			response.setContentType("text/plain");

			response.getOutputStream().println(relImgPaths.size());
			for (String relImgPath : relImgPaths) {
				response.getOutputStream().println(relImgPath);
			}
			return null;
		} catch (Exception x) {
			log.error("getImages", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public static int getFileNumber(String filename) {
		filename = filename.replaceFirst("\\.\\w+$", "");
		Matcher m = fileNumberPattern.matcher(filename);
		if (m.find()) {
			return GenUtils.toInt(m.group(1), -1);
		}
		return -1;
	}

	public ActionForward sendMasks(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> sendMask");
		try {
			UserInfo ui = getUserInfo(request);
			CBFROIForm roiForm = (CBFROIForm) form;
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			String rowsStr = request.getParameter("rows");
			String colsStr = request.getParameter("cols");

			String sliceNoListStr = request.getParameter("sliceNoList");

			System.out.println("rows=" + rowsStr + "  cols=" + colsStr);
			int rows = GenUtils.toInt(rowsStr, 0);
			int cols = GenUtils.toInt(colsStr, 0);

			String[] toks = sliceNoListStr.split(",");
			int[] sliceNos = new int[toks.length];
			List<byte[][]> maskList = new ArrayList<byte[][]>(toks.length);
			StringBuilder snBuf = new StringBuilder(100);
			for (int i = 0; i < toks.length; i++) {
				sliceNos[i] = GenUtils.toInt(toks[i], 0);
				String maskKey = "mask" + i;
				String maskCSVStr = request.getParameter(maskKey);
				byte[][] mask = toMask(rows, cols, maskCSVStr);
				maskList.add(mask);
				snBuf.append(toks[i]).append("\n");
			}

			String cacheDir = roiForm.getContext().getCacheDir();

			File sliceNoFile = new File(cacheDir, "slice_no.txt");
			FileUtils
					.save2File(snBuf.toString(), sliceNoFile.getAbsolutePath());

			for (int i = 0; i < sliceNos.length; i++) {
				String maskFilename = "mask" + sliceNos[i] + ".txt";
				File maskFile = new File(cacheDir, maskFilename);
				saveMask(maskFile, maskList.get(i));
				log.info("saved mask to :" + maskFile);
			}
			String jobID = roiForm.getJobID();
			System.out.println("jobID:" + jobID);

			JobScheduler scheduler = JobScheduler.getInstance();

			scheduler.resumeJob(ui, dbID, ui.getPerceivedName(), jobID);

			response.setContentType("text/plain");
			response.getOutputStream().println("got mask.");

		} catch (Throwable t) {
			log.error("sendMask", t);
			response.setContentType("text/plain");
			response
					.getOutputStream()
					.println(
							"ERROR:A server side error has occurred while receiving masks.");
		}

		return null;
	}

	public ActionForward sendMask(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> sendMask");
		try {
			UserInfo ui = getUserInfo(request);
			CBFROIForm roiForm = (CBFROIForm) form;
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			String rowsStr = request.getParameter("rows");
			String colsStr = request.getParameter("cols");
			String maskCSVStr = request.getParameter("mask");
			String sliceNoStr = request.getParameter("sliceNo");

			System.out.println("rows=" + rowsStr + "  cols=" + colsStr);
			int rows = GenUtils.toInt(rowsStr, 0);
			int cols = GenUtils.toInt(colsStr, 0);
			int sliceNo = GenUtils.toInt(sliceNoStr, 0);

			byte[][] mask = toMask(rows, cols, maskCSVStr);

			String cacheDir = roiForm.getContext().getCacheDir();

			File sliceNoFile = new File(cacheDir, "slice_no.txt");
			FileUtils.save2File(String.valueOf(sliceNo), sliceNoFile
					.getAbsolutePath());

			File maskFile = new File(cacheDir, "mask.txt");
			saveMask(maskFile, mask);
			log.info("saved mask to :" + maskFile);

			String jobID = roiForm.getJobID();
			System.out.println("jobID:" + jobID);

			JobScheduler scheduler = JobScheduler.getInstance();

			scheduler.resumeJob(ui, dbID, ui.getPerceivedName(), jobID);

			response.setContentType("text/plain");
			response.getOutputStream().println("got mask.");

		} catch (Throwable t) {
			log.error("sendMask", t);
			response.setContentType("text/plain");
			response
					.getOutputStream()
					.println(
							"ERROR:A server side error has occurred while receiving mask.");
		}

		return null;
	}

	static byte[][] toMask(int rows, int cols, String maskCSVStr) {
		byte[][] mask = new byte[rows][cols];
		String[] valueStrArr = maskCSVStr.split(",");
		int count = 0;
		for (int i = 0; i < rows; i++) {
			for (int j = 0; j < cols; j++) {
				int value = GenUtils.toInt(valueStrArr[count], 0);
				mask[i][j] = (byte) value;
				count++;
			}
		}
		return mask;
	}

	static void saveMask(File path, byte[][] mask) throws IOException {
		BufferedWriter out = null;
		try {
			out = new BufferedWriter(new FileWriter(path));

            for (byte[] aMask : mask) {
                StringBuilder sb = new StringBuilder(mask[0].length * 2);
                for (int j = 0; j < aMask.length; j++) {
                    sb.append(aMask[j]);
                    if ((j + 1) < aMask.length) {
                        sb.append(' ');
                    }
                }
                out.write(sb.toString());
                out.newLine();
            }
		} finally {
            FileUtils.close(out);
		}
	}

	public ActionForward resumeJob(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> resumeJob");
		try {
			UserInfo ui = getUserInfo(request);
			CBFROIForm roiForm = (CBFROIForm) form;
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			String jobID = roiForm.getJobID();
			System.out.println("jobID:" + jobID);

			JobScheduler scheduler = JobScheduler.getInstance();

			scheduler.resumeJob(ui, dbID, ui.getPerceivedName(), jobID);

			List<JobRecord> jrList = scheduler.getJobsForUser(ui, dbID, ui
					.getPerceivedName());
			JobManForm jmForm = (JobManForm) session
					.getAttribute(Constants.JOB_MAN_FORM_KEY);
			jmForm.setJrList(jrList);
			jmForm.setUser(ui.getPerceivedName());
			return mapping.findForward(Constants.SHOW_JOBS);
		} catch (Exception x) {
			log.error("resumeJob", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}
}
