package clinical.web.actions;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.exolab.castor.xml.ValidationException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.cache.CacheUtils;
import clinical.server.vo.Experiment;
import clinical.utils.Assertion;
import clinical.utils.FileUtils;
import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.web.IAppConfigService;
import clinical.web.ISubjectVisitManagement;
import clinical.web.IUploadManagementService;
import clinical.web.ServiceFactory;
import clinical.web.common.IAuthorizationService;
import clinical.web.common.IAuthorizationService.PrivilegeLabel;
import clinical.web.common.IDBCache;
import clinical.web.common.UserInfo;
import clinical.web.common.vo.AssessmentSelectionInfo;
import clinical.web.forms.CBFUploadForm;
import clinical.web.helpers.CBFUploadHelper;
import clinical.web.helpers.CBFUploadHelper.ExpSubjectInfo;
import clinical.web.services.AppConfigService;
import clinical.web.vo.Visit;
import clinical.web.vo.upload.SeriesHeaderInfo;
import clinical.web.vo.upload.UploadStatusInfo;
import clinical.web.vo.upload.VisitInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class CBFUploadAction extends BaseLookupDispatchAction {

	private Map<String, String> map = new HashMap<String, String>(7);
	private Log log = LogFactory.getLog(CBFUploadAction.class);

	protected Map<String, String> getKeyMethodMap() {
		map.put("action.upload.cbf", "upload");
		map.put("action.upload.view", "viewMain");
		map.put("action.upload.viewVDC", "viewVisitDataCollection");
		map.put("action.upload.hasDuplicateVisit", "checkIfVisitExists");
		map.put("action.upload.visit.info", "uploadVisit");
		return map;
	}

	public ActionForward viewMain(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			getUserInfo(request);
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("viewMain", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward upload(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		JSONObject js = new JSONObject();
		try {
			UserInfo ui = getUserInfo(request);
			CBFUploadForm cuForm = (CBFUploadForm) form;
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			if (cuForm.getTarball() == null) {
				throw new ValidationException(
						"A tar/zip file containing an ASL session needs to be uploaded!");
			}

			IAppConfigService cs = AppConfigService.getInstance();
			String cacheRoot = cs.getParamValue("download.cacheroot");
			if (cacheRoot == null || !new File(cacheRoot).isDirectory()) {
				throw new Exception(
						"Not a valid 'download.cacheroot' directory:"
								+ cacheRoot);
			}
			File workDir = new File(cacheRoot, "upload");
			if (!workDir.exists() || !workDir.isDirectory()) {
				boolean ok = workDir.mkdir();
				if (!ok) {
					throw new Exception("Cannot create directory:" + workDir);
				}
			}

			File theTarFile = null;
			String name = cuForm.getTarball().getFileName();
			System.out.println("name:" + name);
			if (!name.endsWith(".tar") && !name.endsWith(".tar.gz")
					&& !name.endsWith(".tgz") && !name.endsWith(".zip")) {
				cuForm.setTarball(null);
				if (name.trim().length() == 0) {
					throw new ValidationException(
							"A tar/zip file containing an ASL session needs to be uploaded!");
				} else {
					throw new ValidationException(
							"Not a valid (gzipped) tar or zip file:" + name);
				}
			}

			log.info("writing uploaded file to: " + name);
			BufferedInputStream in = null;
			BufferedOutputStream out = null;
			String localPath = null;
			try {
				in = new BufferedInputStream(cuForm.getTarball()
						.getInputStream(), 4096);
				localPath = new File(workDir, name).getAbsolutePath();
				out = new BufferedOutputStream(new FileOutputStream(localPath),
						4096);
				int bytesRead = -1;
				byte[] buf = new byte[4096];
				while ((bytesRead = in.read(buf)) != -1) {
					out.write(buf, 0, bytesRead);
				}

				theTarFile = new File(localPath);
				js.put("name", theTarFile.getName());
				js.put("size", cuForm.getTarball().getFileSize());

			} finally {
				FileUtils.close(in);
				FileUtils.close(out);
				cuForm.setTarball(null);
			}

			IUploadManagementService ums = ServiceFactory
					.getUploadManagementService(dbID);

			UploadStatusInfo usi = ums
					.doUploadStaging(ui, workDir.getAbsolutePath(),
							theTarFile.getName(), null, null);

			if (theTarFile.exists()) {
				theTarFile.delete();
			}

			cuForm.setUsi(usi);

			JSONObject json = usi.toJSONMinimal();

			cuForm.setUsiJSON(json.toString(2));

			CBFUploadHelper helper = new CBFUploadHelper();
			ExpSubjectInfo esi = helper.getExpSubjectInfo(ui, dbID);

			esi.sanitizeProtocols();

			cuForm.setEsi(esi);
			json = esi.toJSON();

			cuForm.setEsiJSON(json.toString());

			Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();
			String primarySiteID = dbID2SiteIDMap.get(dbID);

			List<AssessmentSelectionInfo> asiList = ums.getAssessmentMetaData(
					ui, primarySiteID);
			for (java.util.Iterator<AssessmentSelectionInfo> it = asiList
					.iterator(); it.hasNext();) {
				AssessmentSelectionInfo asi = it.next();
				if (asi.getName().equalsIgnoreCase("subject information")) {
					it.remove();
				}
			}
			JSONObject asiListJSON = toJSON(asiList);
			cuForm.setAsiListJSON(asiListJSON.toString());

			// prepJSONResponse(response, js);
			return mapping.findForward(Constants.NEXT);
		} catch (Exception x) {
			log.error("upload", x);
			// js.put("error", x.getMessage());
			// prepJSONResponse(response, js);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	protected JSONObject toJSON(List<AssessmentSelectionInfo> asiList)
			throws JSONException {
		JSONObject js = new JSONObject();
		JSONArray asiJSArr = new JSONArray();
		js.put("asiList", asiJSArr);
		if (asiList != null) {
			for (AssessmentSelectionInfo asi : asiList) {
				asiJSArr.put(asi.toJSON(new JSONObject()));
			}
		}
		return js;
	}

	protected void prepJSONResponse(HttpServletResponse response, JSONObject js)
			throws IOException {
		response.setContentType("application/json");
		String jsonStr = js.toString();
		response.getOutputStream().println(jsonStr);
	}

	public ActionForward uploadVisit(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		CBFUploadForm cuForm = null;
		try {
			log.info(">> uploadVisit");
			UserInfo ui = getUserInfo(request);
			cuForm = (CBFUploadForm) form;
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			String stagingIdStr = request.getParameter("stagingId");
			int stagingId = GenUtils.toInt(stagingIdStr, -1);

			String jsonStr = request.getParameter("visitInfo");
			System.out.println("visitInfo: " + jsonStr);
			JSONObject js = new JSONObject(jsonStr);
			System.out.println(js.toString(3));

			List<SeriesHeaderInfo> shiList = cuForm.getUsi().getShiList();
			Map<String, SeriesHeaderInfo> shiMap = new HashMap<String, SeriesHeaderInfo>();
			for (SeriesHeaderInfo shi : shiList) {
				shiMap.put(shi.getName(), shi);
			}
			// FIXME handle the case where the series type is unknown
			VisitInfo visitInfo = VisitInfo.initializeFromJSON(js, shiMap);

			IUploadManagementService ums = ServiceFactory
					.getUploadManagementService(dbID);

			ums.uploadVisit(ui, visitInfo, stagingId);

			cuForm.setSubjectID(visitInfo.getSubjectID());
			String visitDate = js.getString("visitDate");
			if (visitDate.indexOf(' ') != -1) {
				String[] parts = visitDate.split("\\s+");
				visitDate = parts[0];
			}
			cuForm.setVisitDate(visitDate);

			IDBCache dbCache = ServiceFactory.getDBCache(dbID);
			List<Experiment> experiments = dbCache.getExperiments(ui, false);
			Experiment theExp = null;
			for (Experiment exp : experiments) {
				if (exp.getUniqueid().intValue() == visitInfo.getExpId()) {
					theExp = exp;
					break;
				}
			}
			Assertion.assertNotNull(theExp);
			cuForm.setExpName(theExp.getName());

			return mapping.findForward(Constants.FINALIZED);

		} catch (Throwable t) {
			log.error("uploadVisit", t);
			if (t instanceof Throwable) {
				return processExceptions(
						request,
						response,
						mapping,
						form,
						new Exception(
								"An unrecoverable error occurred during finalizing the upload!"));

			} else {
				return processExceptions(request, response, mapping, form,
						(Exception) t);
			}
		} finally {
			if (cuForm != null) {
				cuForm.reset();
			}
		}
	}

	public ActionForward viewVisitDataCollection(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		try {
			UserInfo ui = getUserInfo(request);
			CBFUploadForm cuForm = (CBFUploadForm) form;
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			// UploadStatusInfo usi = cuForm.getUsi();

			CBFUploadHelper helper = new CBFUploadHelper();

			ExpSubjectInfo esi = helper.getExpSubjectInfo(ui, dbID);

			cuForm.setEsi(esi);
			JSONObject json = esi.toJSON();

			cuForm.setEsiJSON(json.toString());

			return mapping.findForward(Constants.NEXT);
		} catch (Exception x) {
			log.error("upload", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward checkIfVisitExists(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		try {
			SimpleDateFormat vdf = new SimpleDateFormat("MM/dd/yyyy");
			log.info(">> checkIfVisitExists");
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			String subjectID = request.getParameter("subjectID");
			String expIDStr = request.getParameter("expID");
			int expID = Integer.parseInt(expIDStr);
			String visitDate = request.getParameter("visitDate");

			IAuthorizationService authService = ServiceFactory
					.getAuthorizationService();

			ISubjectVisitManagement isvm = ServiceFactory
					.getSubjectVisitManagement(dbID);
			List<Visit> allVisits = isvm.getAllVisitsForSubject(ui, subjectID);
			boolean duplicateDate = false;
			for (Visit v : allVisits) {
				if (v.getExperimentID() == expID) {
					if (authService.isAuthorized(ui, dbID, PrivilegeLabel.READ,
							expID)) {
						Date vd = new Date(v.getTs().getTime());
						String dateStr = vdf.format(vd);
						if (dateStr.equals(visitDate)) {
							duplicateDate = true;
							break;
						}

					}
				}
			}

			JSONObject js = new JSONObject();
			js.put("visitExists", duplicateDate ? "yes" : "no");

			prepJSONResponse(response, js);

		} catch (Throwable t) {
			log.error("CBFUploadAction", t);
			JSONObject js = new JSONObject();
			js.put("visitExists", "unknown");
			prepJSONResponse(response, js);
		}
		return null;
	}

}
