package clinical.web.actions;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.cache.CacheUtils;
import clinical.cache.DBChangeSupport;
import clinical.web.Constants;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBCache;
import clinical.web.common.UserInfo;

public class CacheRefreshAction extends BaseAction {
	private Log log = LogFactory.getLog(CacheRefreshAction.class);

	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			log.info("in CacheRefreshAction");
			UserInfo ui = getUserInfo(request);
			if (!ui.getName().equals(Constants.ADMIN_USER)) {
				return null;
			}
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			IDBCache dbCache = ServiceFactory.getDBCache(dbID);

			dbCache.getAssessments(ui, true);
			dbCache.getCollectionEquipments(ui, true);
			dbCache.getDataClassications(ui, true);
			dbCache.getDataObjectTypes(ui, true);
			// dbCache.getOntologyConceptMap(ui, true);
			dbCache.getResearchGroups(ui, true);
			dbCache.getResearchGroupTypes(ui, true);
			dbCache.getSecurityClassifications(ui, true);
			dbCache.getSites(ui, true);
			dbCache.getAnimalSpecies(ui, true);
			dbCache.getUserClasses(ui, true);
			dbCache.getUserStatusList(ui, true);
			dbCache.getVisitTypes(ui, true);
			DBChangeSupport dbc = DBChangeSupport.getInstance();
			Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();
			String primarySiteID = dbID2SiteIDMap.get(dbID);
			String[] tablenames = { "nc_assessment", "nc_experiment",
					"nc_dataobjecttype", "nc_expsegment", "nc_extendedtuple",
					"nc_expcomponent" };
			dbc.fireDBChangeEvent(primarySiteID, tablenames);

			return null;
		} catch (Exception x) {
			log.error("CacheRefreshAction", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}
}
