package clinical.web.actions;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.server.vo.ConfWebuser;
import clinical.server.vo.ContactInfo;
import clinical.utils.ValidationUtils;
import clinical.web.Constants;
import clinical.web.ServiceFactory;
import clinical.web.common.UserInfo;
import clinical.web.forms.ContactInfoManForm;
import clinical.web.helpers.CountrySelector;
import clinical.web.helpers.StateSelector;
import clinical.web.services.IContactInfoService;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ContactInfoManAction.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class ContactInfoManAction extends BaseLookupDispatchAction {
	private Map<String, String> map = new HashMap<String, String>(11);
	private Log log = LogFactory.getLog(ContactInfoManAction.class);

	protected Map<String, String> getKeyMethodMap() {
		map.put("action.contact.view", "viewMain");
		map.put("action.contact.save", "save");
		return map;
	}

	public ActionForward viewMain(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> viewMain");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			ContactInfoManForm ciForm = (ContactInfoManForm) form;

			if (ciForm.getCountrySelector() == null) {
				ciForm.setCountrySelector(new CountrySelector());
			}
			if (ciForm.getStateSelector() == null) {
				ciForm.setStateSelector(new StateSelector());
			}

			IContactInfoService cis = ServiceFactory
					.getContactInfoService(dbID);

			ContactInfo contactInfo = cis.getContactInfo(ui);
			ConfWebuser webUser = cis.getWebUser(ui);
			ciForm.setEmail(webUser.getEmail());
			ciForm.setUsername(webUser.getName());
			if (contactInfo == null) {
				contactInfo = new ContactInfo();
				contactInfo.setWebuserId(webUser.getUniqueId());
			} else {
				if (contactInfo.getState() != null) {
					ciForm.getStateSelector().setSelectedState(
							contactInfo.getState());
				}
				if (contactInfo.getCountry() != null) {
					ciForm.getCountrySelector().setSelectedCountry(
							contactInfo.getCountry());
				}
			}
			ciForm.setContactInfo(contactInfo);
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("viewMain", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward save(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> save");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			ContactInfoManForm ciForm = (ContactInfoManForm) form;
			IContactInfoService cis = ServiceFactory
					.getContactInfoService(dbID);

			ContactInfo contactInfo = ciForm.getContactInfo();
			ValidationUtils.notEmpty("First Name", contactInfo.getFirstName());
			ValidationUtils.notEmpty("Last Name", contactInfo.getLastName());
			

			contactInfo.setState(ciForm.getStateSelector().getSelectedState());
			contactInfo.setCountry(ciForm.getCountrySelector()
					.getSelectedCountry());

			cis.saveContactInfo(ui, contactInfo);

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("save", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}
}
