package clinical.web.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.json.JSONObject;

import clinical.server.vo.Experiment;
import clinical.utils.Assertion;
import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.web.IAppConfigService;
import clinical.web.ICBFWFManagementService;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBCache;
import clinical.web.common.ISecurityService;
import clinical.web.common.UserInfo;
import clinical.web.common.security.DBConfig;
import clinical.web.common.security.User;
import clinical.web.exception.ValidationException;
import clinical.web.forms.DTIJobManForm;
import clinical.web.helpers.CBFBirnHelper;
import clinical.web.helpers.SubjectExperimentsSelector;
import clinical.web.scheduler.JobScheduler;
import clinical.web.scheduler.JobScheduler.JobSubmissionType;
import clinical.web.vo.upload.VisitInfo;
import clinical.web.workflow.dti.DTIProcessingJob;
import clinical.web.workflow.dti.DTIWFContext;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: DTIJobManAction.java 537 2012-02-08 21:01:26Z bozyurt $
 */
public class DTIJobManAction extends BaseLookupDispatchAction {
	private Map<String, String> map = new HashMap<String, String>(11);
	private Log log = LogFactory.getLog(DTIJobManAction.class);

	protected Map<String, String> getKeyMethodMap() {
		map.put("action.dtijob.view", "viewMain");
		map.put("action.dtijob.submitjob", "submitJob");
		return map;
	}

	public ActionForward viewMain(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> viewMain");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			DTIJobManForm dtiForm = (DTIJobManForm) form;

			ICBFWFManagementService cbfService = ServiceFactory
					.getCBFWFManagementService(dbID);

			Map<String, List<VisitInfo>> exp2ViListMap = cbfService
					.getScanVisits(ui);

			exp2ViListMap = CBFBirnHelper.filterNonDTI(exp2ViListMap);

			dtiForm.setExp2ViListMap(exp2ViListMap);

			JSONObject json = CBFBirnHelper
					.prepareExp2ViListMapAsJSON(exp2ViListMap);
			log.info(json.toString(3));

			dtiForm.setExp2ViListJSON(json.toString());

			if (exp2ViListMap.isEmpty()) {
				dtiForm.setHasData(false);

			} else {
				dtiForm.setHasData(true);
				IDBCache dbCache = ServiceFactory.getDBCache(dbID);
				List<Experiment> experiments = dbCache.getExperiments(ui, true);
				List<Experiment> usedExpList = new ArrayList<Experiment>(
						experiments.size());
				for (Experiment exp : experiments) {
					if (exp2ViListMap.containsKey(exp.getName())) {
						usedExpList.add(exp);
					}
				}

				SubjectExperimentsSelector expSelector = new SubjectExperimentsSelector(
						usedExpList);
				dtiForm.setExpSelector(expSelector);

			}
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("viewMain", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward submitJob(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> submitJob");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			DTIJobManForm dtiForm = (DTIJobManForm) form;

			String[] values = request.getParameterValues("viSelector");
			if (values != null && values.length > 0) {
				for (int i = 0; i < values.length; i++) {
					System.out.println("VisitInfo: " + values[i]);
				}
			}
			String visitInfo = values[0];
			VisitInfo selVI = getSelectedVisitInfo(dtiForm, visitInfo);

			Assertion.assertNotNull(selVI);

			ICBFWFManagementService cbfService = ServiceFactory
					.getCBFWFManagementService(dbID);

			List<VisitInfo> viList = new ArrayList<VisitInfo>(1);
			viList.add(selVI);
			// remove partially loaded segment data list  for full segment info retrieval
			selVI.getSiList().clear();

			List<VisitInfo> visitInfosWithScans = cbfService
					.getVisitInfosWithScans(ui, viList);

			String id = String.valueOf(System.currentTimeMillis());
			String description = "DTI processing for '" + visitInfo + "'";

			IAppConfigService configService = ServiceFactory
					.getAppConfigService();

			String cacheRoot = configService
					.getParamValue("download.cacheroot");
			if (cacheRoot == null || cacheRoot.trim().length() == 0) {
				throw new ValidationException(
						"System Setup Problem: A valid cache root directory needs to be supplied "
								+ "during system setup with property download.cacheroot:! ");
			}

			String workDir = visitInfo + "_dti_" + id;
			File cacheDir = new File(cacheRoot, workDir);
			cacheDir.mkdirs();
			String templateDir = super.servlet.getServletContext().getRealPath(
					Constants.TEMPLATE_DIR);

			DTIWFContext ctx = new DTIWFContext(dbID, cacheDir
					.getAbsolutePath(), visitInfosWithScans);
			DBConfig dbConfig = ServiceFactory.getSecurityAdminService()
					.getDBConfigMap().get(dbID);
			User user = dbConfig.findUser(ui.getName());

			if (user.getEmail() == null) {
				ISecurityService secService = ServiceFactory
						.getSecurityService();
				String email = secService.getEmail(ui.getName());
				user.setEmail(email);
			}

			log.info("DTIJobManAction:: emailTo:" + user.getEmail());
			ctx.setEmailTo(user.getEmail());
			ctx.setTemplateDir(templateDir);

			DTIProcessingJob job = new DTIProcessingJob(id, ui, description,
					ctx, templateDir, user.getEmail());
			
			// schedule job
			JobScheduler scheduler = JobScheduler.getInstance();
			scheduler.addJob(job, JobSubmissionType.INDIVIDUAL);
			
			dtiForm.setSubmittedJobId(id);
			dtiForm.setSubmittedSubjectId(selVI.getSubjectID());

			return mapping.findForward(Constants.SUBMITTED);
		} catch (Exception x) {
			log.error("submitJob", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	private VisitInfo getSelectedVisitInfo(DTIJobManForm dtiForm,
			String visitInfo) {
		int idx = visitInfo.lastIndexOf('_');
		Assertion.assertTrue(idx != -1);
		String selSubjectID = visitInfo.substring(0, idx);
		int selVisitID = GenUtils.toInt(visitInfo.substring(idx + 1), -1);

		String selExpName = dtiForm.getExpSelector()
				.getSelectedExperimentName();
		List<VisitInfo> viList = dtiForm.getExp2ViListMap().get(selExpName);
		VisitInfo selVI = null;
		for (VisitInfo vi : viList) {
			if (vi.getSubjectID().equals(selSubjectID)
					&& vi.getVisitId() == selVisitID) {
				selVI = vi;
				break;
			}
		}
		return selVI;
	}
}
