package clinical.web.actions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.server.vo.ConfWebuser;
import clinical.utils.Assertion;
import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.web.IAppConfigService;
import clinical.web.IExperimentManagement;
import clinical.web.ServiceFactory;
import clinical.web.common.ISecurityService;
import clinical.web.common.UserInfo;
import clinical.web.forms.ExperimentAprovalManForm;
import clinical.web.helpers.EmailHelper;
import clinical.web.services.SecurityService;
import clinical.web.vo.ExperimentInfo;
import clinical.web.vo.ProjectInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */

public class ExperimentApprovalManAction extends BaseLookupDispatchAction {
	private Map<String, String> map = new HashMap<String, String>(11);
	private Log log = LogFactory.getLog(ExperimentApprovalManAction.class);

	protected Map<String, String> getKeyMethodMap() {
		map.put("action.eam.view", "viewMain");
		map.put("action.eam.approve", "approve");
		return map;
	}

	public ActionForward viewMain(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> viewMain");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			IExperimentManagement ems = ServiceFactory
					.getExperimentManagement(dbID);
			List<ProjectInfo> piList = ems.getProjectInfos(ui, null, null);
			ExperimentAprovalManForm eamForm = (ExperimentAprovalManForm) form;
			eamForm.setPiList(piList);
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("viewMain", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward approve(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> approve");
		ProjectInfo thePI = null;
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			ExperimentAprovalManForm eamForm = (ExperimentAprovalManForm) form;
			if (eamForm.getSelectedExpId() == null
					|| eamForm.getSelectedExpId().trim().length() == 0) {
				throw new Exception(
						"No project selection information has been found!");
			}
			String selExpID = eamForm.getSelectedExpId().trim();
			for (ProjectInfo pi : eamForm.getPiList()) {
				if (pi.getExperiment().getUniqueid().toString()
						.equals(selExpID)) {
					thePI = pi;
					break;
				}
			}

			Assertion.assertNotNull(thePI);
			IExperimentManagement ems = ServiceFactory
					.getExperimentManagement(dbID);

			thePI.getExperiment().setApproved(Boolean.TRUE);
			ExperimentInfo expInfo = new ExperimentInfo(thePI.getExperiment());
			ems.updateExperiment(ui, expInfo);

			// send email to the PI
			if (thePI.getContactInfo() != null
					&& thePI.getContactInfo().getWebuserId() != null) {
				ISecurityService iss = ServiceFactory.getSecurityService();
				ConfWebuser wu = ((SecurityService) iss).getWebUserById(thePI
						.getContactInfo().getWebuserId());
				String toEmail = wu.getEmail();
				String templateDir = super.servlet.getServletContext()
						.getRealPath(Constants.TEMPLATE_DIR);
				if (toEmail != null) {
					Map<String, String> paramMap = new HashMap<String, String>(
							7);
					paramMap.put("expName", thePI.getExperiment().getName());
					String lastName = thePI.getContactInfo().getLastName();
					if (lastName == null || lastName.length() == 0) {
						lastName = toEmail;
					}
					paramMap.put("lastName", lastName);
					String emailSubjectLine = "Your CBFDAP project '"
							+ thePI.getExperiment().getName()
							+ "' has been approved";
					handleEmail(templateDir, toEmail, paramMap,
							emailSubjectLine);
				}
			}

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("approve", x);
			if (thePI != null) {
				// rollback local change
				if (thePI.getExperiment().getApproved().booleanValue()) {
					thePI.getExperiment().setApproved(Boolean.FALSE);
				}
			}
			return processExceptions(request, response, mapping, form, x);
		}
	}

	protected boolean handleEmail(String templateDir, String toEmail,
			Map<String, String> paramMap, String emailSubjectLine)
			throws Exception {
		IAppConfigService configService = ServiceFactory.getAppConfigService();

		String emailHost = configService.getParamValue("email.host");
		String emailUser = configService.getParamValue("email.user");
		String emailPwd = configService.getParamValue("email.pwd");
		String emailFrom = configService.getParamValue("email.from");
		boolean canSendEmail = GenUtils.hasEnoughInfoForEmail(emailHost, emailFrom);
		

		if (canSendEmail) {
			EmailHelper helper = new EmailHelper(emailHost, emailUser,
					emailPwd, emailFrom);

			try {
				helper.sendEmail(toEmail, emailSubjectLine, paramMap,
						templateDir, "project_approved.vm", false);
			} catch (Throwable t) {
				log.error("sendEmail", t);
			}
		}
		return canSendEmail;
	}
}
