package clinical.web.actions;

import java.io.File;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.jdom.CDATA;
import org.jdom.Element;

import clinical.utils.FileUtils;
import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.web.SessionStateCoordinator;
import clinical.web.common.UserInfo;
import clinical.web.forms.JobManForm;
import clinical.web.scheduler.JobRecord;
import clinical.web.scheduler.JobScheduler;

/**
 * @author I. Burak Ozyurt
 * @version $Id: JobManAction.java 640 2012-07-31 00:55:41Z bozyurt $
 */
public class JobManAction extends BaseLookupDispatchAction {
	protected Map<String, String> map = new HashMap<String, String>(7);
	private Log log = LogFactory.getLog(JobManAction.class);

	protected Map<String, String> getKeyMethodMap() {
		map.put("button.jobman.check4Jobs", "checkForJobs");
		map.put("button.jobman.showJobs", "showCurrentJobs");
		map.put("button.jobman.download", "downloadResults");
		map.put("button.removeJob", "removeJob");
		map.put("button.cancelJob", "cancelJob");
		map.put("button.jobman.updateNotifiedState", "updateNotifiedState");
		return map;
	}

	public ActionForward showCurrentJobs(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		try {
			UserInfo ui = getUserInfo(request);
			JobScheduler scheduler = JobScheduler.getInstance();
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			List<JobRecord> jrList = scheduler.getJobsForUser(ui, dbID,
					ui.getPerceivedName());
			JobManForm jmForm = (JobManForm) form;
			jmForm.setJrList(jrList);
			jmForm.setUser(ui.getPerceivedName());

			return mapping.findForward(Constants.SHOW_JOBS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward downloadResults(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		try {
			log.info("in downloadResults");
			UserInfo ui = getUserInfo(request);
			String jobID = request.getParameter("jobID");
			log.info("JobID=" + jobID);
			String fileID = request.getParameter("fileID");
			log.info("fileID=" + fileID);
			JobScheduler scheduler = JobScheduler.getInstance();
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			JobRecord jr = scheduler.getJobRecord(ui, dbID,
					ui.getPerceivedName(), jobID);
			int fileIdx = GenUtils.toInt(fileID, 0);
			String resultsFile = jr.getSavedResultFiles()[fileIdx];
			log.info("resultsFile: " + resultsFile);

			response.setContentType("application/octet-stream");
			// as of RFC 2183
			response.setHeader("Content-Disposition", "attachment; filename="
					+ new File(resultsFile).getName());

			// let's the browser to not cache this page
			response.setHeader("CACHE-CONTROL", "no-cache");
			response.setHeader("expires", "0");

			try {
				OutputStream os = response.getOutputStream();
				FileUtils.copyContent(resultsFile, os);
			} finally {
				FileUtils.close(response.getOutputStream());
			}

			jr.setDownloadCount(jr.getDownloadCount() + 1);
			jr.setLastDownloadTime(new Date());
			// jr.setJobSize(new File(resultsFile).length());
			scheduler.updateJob(ui, dbID, jr);

			return null;
		} catch (Throwable t) {
			Exception x = (t instanceof Exception) ? (Exception) t
					: new Exception(t);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward updateNotifiedState(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		try {
			getUserInfo(request);
			JobManForm jmForm = (JobManForm) form;
			String jobIDsStr = request.getParameter("jobIDs");
			System.out.println("updateNotifiedState:: jobIDs:" + jobIDsStr);
			if (jobIDsStr != null) {
				String[] jobIDs = jobIDsStr.split(",");
                for (String jobID : jobIDs) {
                    if (!jmForm.getJobIDSet().contains(jobID)) {
                        jmForm.addJobID(jobID);
                    }
                }
			}

			response.setContentType("text/xml");
			Element rootElem = new Element("jobs");
			FileUtils.saveXML(rootElem, response.getOutputStream());

			return null;
		} catch (Throwable t) {
			Exception x = (t instanceof Exception) ? (Exception) t
					: new Exception(t);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward checkForJobs(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			// log.info("in checkForJobs");
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			SessionStateCoordinator ssc = (SessionStateCoordinator) session
					.getAttribute(Constants.SESSION_STATE_COORDINATOR_KEY);

			long loginTime = -1;
			if (ssc != null) {
				loginTime = ssc.getLoginTime();
				//log.info("loginTime:" + loginTime);
			}

			response.setContentType("text/xml");
			JobScheduler scheduler = JobScheduler.getInstance();
			List<JobRecord> jrList = scheduler.getJobsForUser(ui, dbID,
					ui.getPerceivedName());

			Element rootElem = new Element("jobs");
			for (JobRecord jr : jrList) {
				if (loginTime > 0 && jr.getDateFinished() != null) {
					if (jr.getDateFinished().getTime() > loginTime) {
						jr.setNewlyAdded(true);
						// log.info("newly finished job:" + jr);
					} else {
						jr.setNewlyAdded(false);
					}
				}
				/*
				 * if (!jmForm.getJobIDSet().contains(jr.getJobID())) {
				 * jr.setNewlyAdded(true); } else { jr.setNewlyAdded(false); }
				 */

				for (int i = 0; i < jr.getSavedResultFiles().length; i++) {
					Element jrElem = new Element("jr");
					String status = jr.getStatus();
					if (jr.getStatusDetail() != null) {
						status += "(" + jr.getStatusDetail() + ")";
					}

					jrElem.setAttribute("id", jr.getJobID());
					jrElem.setAttribute("user", jr.getUser());
					jrElem.setAttribute("status", status);
					jrElem.setAttribute("date", jr.getDate().toString());
					jrElem.setAttribute("type", jr.getType());
					jrElem.setAttribute("partNum", String.valueOf(i));
					jrElem.setAttribute("new",
							String.valueOf(jr.isNewlyAdded()));
					if (jr.getStatusDetail() != null) {
						jrElem.setAttribute("statusDetail",
								jr.getStatusDetail());
					}
					Element descElem = new Element("desc");
					descElem.addContent(new CDATA(jr.getDescription()));
					jrElem.addContent(descElem);
					if (jr.getJobSize() > 0) {
						jrElem.setAttribute("size",
								GenUtils.formatFileSize(jr.getJobSize()));
					}
					if (jr.getDownloadCount() > 0) {
						jrElem.setAttribute("count",
								String.valueOf(jr.getDownloadCount()));
					}
					if (jr.getErrorMsg() != null) {
						Element errElem = new Element("error");

						errElem.addContent(new CDATA(jr.getErrorMsg()));
						jrElem.addContent(errElem);
					}
					// System.out.println("+++++++++ " + jr.getJobID() + " :
					// desc:"
					// + jr.getDescription());
					rootElem.addContent(jrElem);
				}
			}

			// for Debugging
			// FileUtils.saveXML(rootElem, System.out );
			try {
				FileUtils.saveXML(rootElem, response.getOutputStream());
			} catch (SocketException se) {
				// log any broken pipe etc socket exceptions, in case client
				// logout happend during an AJAX pull, but do nothing besides
				log.info(se.getMessage());
			}
			return null;
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

    public ActionForward removeJob(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		UserInfo ui = getUserInfo(request);

		String jobID = request.getParameter("jobID");
		System.out.println("JobID=" + jobID);
		JobScheduler scheduler = JobScheduler.getInstance();
		HttpSession session = request.getSession(false);
		String dbID = (String) session.getAttribute(Constants.SESSION_DBID_KEY);

		scheduler.removeJob(ui, dbID, ui.getPerceivedName(), jobID);
		List<JobRecord> jrList = scheduler.getJobsForUser(ui, dbID,
				ui.getPerceivedName());
		JobManForm jmForm = (JobManForm) form;
		jmForm.setJrList(jrList);

		return mapping.findForward(Constants.SHOW_JOBS);
	}

	public ActionForward cancelJob(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		UserInfo ui = getUserInfo(request);

		String jobID = request.getParameter("jobID");
		System.out.println("JobID=" + jobID);
		JobScheduler scheduler = JobScheduler.getInstance();
		HttpSession session = request.getSession(false);
		String dbID = (String) session.getAttribute(Constants.SESSION_DBID_KEY);

		scheduler.cancelJob(ui, dbID, ui.getPerceivedName(), jobID);
		List<JobRecord> jrList = scheduler.getJobsForUser(ui, dbID,
				ui.getPerceivedName());
		JobManForm jmForm = (JobManForm) form;
		jmForm.setJrList(jrList);

		return mapping.findForward(Constants.SHOW_JOBS);
	}
}
