package clinical.web.actions;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.FormBeanConfig;

import clinical.web.game.AssessmentManagementHelper;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SegmentManagementHelper.java,v 1.7 2005/09/09 01:47:39 bozyurt
 *          Exp $
 */

public class SegmentManagementHelper {
	private Log log = LogFactory.getLog(SegmentManagementHelper.class);

	public SegmentManagementHelper() {
	}

	public List<String> getEditableAssessments(
			Map<String, String> assessmentNamesMap) throws Exception {
		AssessmentManagementHelper amh = AssessmentManagementHelper
				.getInstance("clinical.web.game.forms");
		List<String> asNames = new LinkedList<String>();
		for (String asName : amh.getAssessmentNames()) {
			if (assessmentNamesMap.get(asName) != null) {
				asNames.add(asName);
			}
		}
		return asNames;
	}

	public String findFormBeanClassName(String asName) throws Exception {
		AssessmentManagementHelper amh = AssessmentManagementHelper
				.getInstance("clinical.web.game.forms");
		return amh.findFormBeanClassName(asName);
	}

	/**
	 * Given an <code>ActionMapping</code> and form bean class name finds the
	 * name of the form bean
	 * 
	 * @param mapping
	 * @param formBeanClass
	 * @return
	 */
	public String findFormBeanName(ActionMapping mapping, String formBeanClass) {
		FormBeanConfig[] fbConfigs = mapping.getModuleConfig()
				.findFormBeanConfigs();
		for (int i = 0; i < fbConfigs.length; i++) {
			System.out.println("******* formBeanType = "
					+ fbConfigs[i].getType());
			if (fbConfigs[i].getType().equals(formBeanClass)) {
				return fbConfigs[i].getName();
			}
		}
		return null;
	}

	public List<String> findGAMEFormBeansInSession(ActionMapping mapping,
			HttpSession session) {

		Map<String, String> allGAMEFormBeansMap = new HashMap<String, String>(
				17);
		FormBeanConfig[] fbConfigs = mapping.getModuleConfig()
				.findFormBeanConfigs();
		for (int i = 0; i < fbConfigs.length; i++) {
			if (fbConfigs[i].getType().startsWith("clinical.web.game.forms")) {
				allGAMEFormBeansMap.put(fbConfigs[i].getName(), fbConfigs[i]
						.getName());
			}
		}
		List<String> gfbList = new LinkedList<String>();
		Enumeration<?> enumeration = session.getAttributeNames();
		while (enumeration.hasMoreElements()) {
			String attrName = (String) enumeration.nextElement();
			if (allGAMEFormBeansMap.get(attrName) != null) {
				gfbList.add(attrName);
			}
		}
		return gfbList;
	}

	public ActionForm createFormBean(String formBeanClass) throws Exception {
		AssessmentManagementHelper.getInstance("clinical.web.game.forms");
		return (ActionForm) Class.forName(formBeanClass).newInstance();
	}

	public void setProperty(String propertyMethodName, Object value, Object bean)
			throws Exception {
		Class<?> clazz = bean.getClass();
		log
				.info("propertyMethodName:" + propertyMethodName + " value="
						+ value);
		Method m = clazz.getMethod(propertyMethodName, new Class[] { value
				.getClass() });
		m.invoke(bean, new Object[] { value });
	}
}
