package clinical.web.actions;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.web.Constants;
import clinical.web.IAssessmentService;
import clinical.web.ServiceFactory;
import clinical.web.common.UserInfo;
import clinical.web.exception.BaseException;
import clinical.web.forms.AsQueryBuilderForm;
import clinical.web.helpers.QueryWizardHelper;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SelectSubcorticalsAction.java,v 1.8 2005/09/09 01:47:39 bozyurt
 *          Exp $
 */

public class SelectSubcorticalsAction extends BaseLookupDispatchAction {
	protected Map<String, String> buttonMap = new HashMap<String, String>(3);
	private Log log = LogFactory.getLog(SelectSubcorticalsAction.class);

	public SelectSubcorticalsAction() {
	}

	protected Map<String, String> getKeyMethodMap() {
		buttonMap.put("button.continue", "nextPage");
		buttonMap.put("button.previous", "prevPage");
		return buttonMap;
	}

	public ActionForward nextPage(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		IAssessmentService asService = null;
		// IDerivedDataService dService = null;
		log.debug("**** SelectSubcorticalsAction");
		try {
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			// dService = ServiceFactory.getDerivedDataService(dbID);
			asService = ServiceFactory.getAssessmentService(dbID);

			QueryWizardHelper qwHelper = new QueryWizardHelper();

			UserInfo ui = getUserInfo(request);
			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) form;
			String state = queryForm.getState();

			log.debug("*** SelectSubcorticalsAction state=" + state);

			if (!queryForm.getState().equals(Constants.SEL_DERIVED)) {
				throw new BaseException("", "wizard.out_of_order");
			}

			qwHelper.prepareSubCorticalQueryParts(request, queryForm);

			// retrieve range info from the database and associate them with
			// the corresponding query part (for subcortical variables only)
			qwHelper.prepareRangeInfos(ui, queryForm, asService, true);

			queryForm.setState(Constants.COLLECT_QUERY);
			log.debug("after SelectSubCorticalAction");
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error(x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward prevPage(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			request.getSession(false);
			QueryWizardHelper qwHelper = new QueryWizardHelper();

			getUserInfo(request);
			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) form;

			// applies the user selections and creates query parts
			qwHelper.prepareSubCorticalQueryParts(request, queryForm);

			String state = queryForm.getState();

			String prevState = qwHelper.previousPage(queryForm, state);
			queryForm.setState(prevState);

			return mapping.findForward(prevState);
		} catch (Exception x) {
			log.error(x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public void cleanupAfterException(HttpServletRequest request,
			HttpServletResponse response, ActionMapping mapping,
			ActionForm form, BaseException be) {
		((AsQueryBuilderForm) form).clean();
	}

}
