package clinical.web.actions;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.web.common.UserInfo;
import clinical.web.services.HelpService;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class ServiceDataRefreshAction extends BaseAction {
	private Log log = LogFactory.getLog(ServiceDataRefreshAction.class);

	@Override
	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			UserInfo ui = getUserInfo(request);
			if (ui.getName().equals("admin")) {
				HelpService.getInstance().update();
				log.info("refreshed help service data!");
			}

		} catch (Exception x) {
			log.error(x);
		}
		return null;
	}
}
