package clinical.web.actions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.web.Constants;
import clinical.web.ISubjectVisitManagement;
import clinical.web.ServiceFactory;
import clinical.web.common.UserInfo;
import clinical.web.forms.SubjectVisitManagementForm;
import clinical.web.helpers.SearchResultsIterator;
import clinical.web.vo.Subject;
import clinical.web.vo.Visit;

/**
 * 
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SubjectSRNavigateAction.java,v 1.6 2005/09/09 01:47:39 bozyurt
 *          Exp $
 */
public class SubjectSRNavigateAction extends BaseLookupDispatchAction {
	protected Map<String, String> map = new HashMap<String, String>(5);

	public SubjectSRNavigateAction() {
	}

	protected Map<String, String> getKeyMethodMap() {
		map.put("button.next", "nextWindow");
		map.put("button.prev", "prevWindow");
		map.put("button.subject_edit", "editSubject");
		map.put("button.subject_delete", "deleteSubject");

		return map;
	}

	public ActionForward prevWindow(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			getUserInfo(request);
			HttpSession session = request.getSession(false);

			SubjectVisitManagementForm queryForm = (SubjectVisitManagementForm) session
					.getAttribute(Constants.SUBVISITMANAGEMENT_FORM_KEY);
			String action = queryForm.getCurrentAction();

			log.debug("*** ASQUERYACTION action=" + action);
			SearchResultsIterator srit = queryForm.getSearchResultsIterator();
			srit.moveToPrevWindow();
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward nextWindow(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			getUserInfo(request);
			HttpSession session = request.getSession(false);
			SubjectVisitManagementForm queryForm = (SubjectVisitManagementForm) session
					.getAttribute(Constants.SUBVISITMANAGEMENT_FORM_KEY);
			String action = queryForm.getCurrentAction();

			log.debug("*** ASQUERYACTION action=" + action);
			SearchResultsIterator srit = queryForm.getSearchResultsIterator();
			srit.moveToNextWindow();
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward editSubject(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		ISubjectVisitManagement svm = null;
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) session
					.getAttribute(Constants.SUBVISITMANAGEMENT_FORM_KEY);
			log.debug("editing the subject " + svmForm.getSelectedSubjectID());

			svm = ServiceFactory.getSubjectVisitManagement(dbID);
			Subject subject = svmForm.findSubject(svmForm
					.getSelectedSubjectID());
			subject.clearVisits();
			List<Visit> visits = svm.getAllVisitsForSubject(ui, svmForm
					.getSelectedSubjectID());
			for (Visit visit : visits) {
				if (visit.getVisitType().equals(Constants.VISIT_TYPE_CLINICAL)) {
					subject.addClinicalVisit(visit);
				} else if (visit.getVisitType().equals(
						Constants.VISIT_TYPE_SCAN)) {
					subject.addScanVisit(visit);
				}
			}

			svmForm.setSubject(subject);
			return mapping.findForward(Constants.EDIT_SUBJECT);

		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);

		}
	}

	public ActionForward deleteSubject(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			getUserInfo(request);
			HttpSession session = request.getSession(false);
			SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) session
					.getAttribute(Constants.SUBVISITMANAGEMENT_FORM_KEY);

			log.debug("deleting the subject " + svmForm.getSelectedSubjectID());
			/** @todo */
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

}