package clinical.web.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.server.vo.ConfWebuser;
import clinical.server.vo.ContactInfo;
import clinical.web.Constants;
import clinical.web.ServiceFactory;
import clinical.web.common.UserInfo;
import clinical.web.forms.UsageContactReportForm;
import clinical.web.services.IContactInfoService;
import clinical.web.services.IUsageManagementService;
import clinical.web.vo.UsageAndContactInfo;
import clinical.web.vo.UsageInfo;

public class UsageContactReportAction extends BaseLookupDispatchAction {
	private Map<String, String> map = new HashMap<String, String>(11);
	private Log log = LogFactory.getLog(UsageContactReportAction.class);

	protected Map<String, String> getKeyMethodMap() {
		map.put("action.ucreport.view", "viewMain");
		return map;
	}

	public ActionForward viewMain(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> viewMain");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			UsageContactReportForm ucrForm = (UsageContactReportForm) form;
			IContactInfoService cis = ServiceFactory
					.getContactInfoService(dbID);
			
			IUsageManagementService ums = ServiceFactory.getUsageManagementService(dbID);
			
			Map<ConfWebuser, List<UsageInfo>> usagesMap = ums.getAllUsages(ui);
			Map<ConfWebuser, ContactInfo> ciMap = cis.getAllContactInfos(ui);
			List<UsageAndContactInfo> uciList = new ArrayList<UsageAndContactInfo>( usagesMap.size());
			for(ConfWebuser wu : ciMap.keySet()) {
				ContactInfo contactInfo = ciMap.get(wu);
				UsageAndContactInfo uci = new UsageAndContactInfo();
				uci.setContactInfo(contactInfo);
				uci.setEmail(wu.getEmail());
				uci.setUsername(wu.getName());
				List<UsageInfo> list = usagesMap.get(wu);
				if (list != null) {
					uci.setUsageInfos(list);
				}
				uciList.add(uci);
			}
		
			// sort by web user name 
			Collections.sort(uciList, new Comparator<UsageAndContactInfo>() {
				public int compare(UsageAndContactInfo o1,
						UsageAndContactInfo o2) {
					return o1.getUsername().compareTo(o2.getUsername());
				}
			});
			
			ucrForm.setUciList(uciList);

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("viewMain", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}
}
