package clinical.web.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.server.vo.Experiment;
import clinical.server.vo.Publication;
import clinical.utils.ValidationUtils;
import clinical.web.Constants;
import clinical.web.ServiceFactory;
import clinical.web.common.IAuthorizationService;
import clinical.web.common.IDBCache;
import clinical.web.common.UserInfo;
import clinical.web.common.IAuthorizationService.PrivilegeLabel;
import clinical.web.forms.UsageManForm;
import clinical.web.helpers.RefIdTypeSelector;
import clinical.web.helpers.UsageExperimentSelector;
import clinical.web.services.IUsageManagementService;
import clinical.web.vo.UsageInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: UsageManAction.java 559 2012-03-10 01:05:59Z bozyurt $
 */

public class UsageManAction extends BaseLookupDispatchAction {
	private Map<String, String> map = new HashMap<String, String>(11);
	private Log log = LogFactory.getLog(UsageManAction.class);

	protected Map<String, String> getKeyMethodMap() {
		map.put("action.usage.view", "viewMain");
		map.put("action.usage.save", "saveUsage");
		map.put("action.usage.addref", "addRef");
		map.put("action.usage.changeExp", "changeExperiment");
		return map;
	}
	
	public ActionForward viewMain(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> viewMain");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			UsageManForm umForm = (UsageManForm) form;
			
			IAuthorizationService authService = ServiceFactory
			.getAuthorizationService();

			IDBCache dbCache = ServiceFactory.getDBCache(dbID);
			List<Experiment> allExps = dbCache.getExperiments(ui, false);
			List<Experiment> userExps = new ArrayList<Experiment>(allExps.size());
			for (Experiment exp : allExps) {
				if (authService.isAuthorized(ui, dbID, PrivilegeLabel.UPDATE, exp
						.getUniqueid().intValue())) {
					userExps.add(exp);
				}
			}
			UsageExperimentSelector usageExpSelector = new UsageExperimentSelector(userExps);
			umForm.setUsageExpSelector(usageExpSelector);
			umForm.setRefIdTypeSelector( new RefIdTypeSelector());
			
			IUsageManagementService ums = ServiceFactory.getUsageManagementService(dbID);			
			List<UsageInfo> usageInfoList = ums.findUsageData(ui);
			if (usageInfoList.isEmpty()) {
				for(Experiment exp : userExps) {
					UsageInfo usageInfo = new UsageInfo(exp);
					usageInfoList.add(usageInfo);
				}
			} else {
				List<UsageInfo> temp = new ArrayList<UsageInfo>( userExps.size());
				for(Experiment exp : userExps) {
					UsageInfo theUsageInfo = null;
					for(UsageInfo usageInfo : usageInfoList) {
						if (usageInfo.getExperiment().getUniqueid().equals(exp.getUniqueid())) {
							theUsageInfo = usageInfo;
							break;
						}
					}
					if (theUsageInfo == null) {
						UsageInfo usageInfo = new UsageInfo(exp);
						temp.add(usageInfo);
					} else {
						temp.add(theUsageInfo);
					}
				}
				usageInfoList = temp;
			}
			
			umForm.setUsageInfoList(usageInfoList);
			
			umForm.setSelectedUsageInfo(usageInfoList.get(0));
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("viewMain", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}
	
	public ActionForward changeExperiment(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> changeExperiment");
		try {
			getUserInfo(request);
			UsageManForm umForm = (UsageManForm) form;
			UsageExperimentSelector expSelector = umForm.getUsageExpSelector();
			int selectedExpID = expSelector.getSelectedExpID();
			log.info("selectedExpId:" + selectedExpID);
			UsageInfo selUsageInfo = null;
			for(UsageInfo usageInfo : umForm.getUsageInfoList()) {
				int expId = usageInfo.getExperiment().getUniqueid().intValue();
				if (expId == selectedExpID) {
					selUsageInfo = usageInfo;
					break;
				}
			}
			if (selUsageInfo != null) {
				umForm.setSelectedUsageInfo(selUsageInfo);
			}
			umForm.setReference(null);
			umForm.setReferenceId(null);
			
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("changeExperiment", x);
			return processExceptions(request, response, mapping, form, x);
		}	
	}
	
	public ActionForward saveUsage(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> saveUsage");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			UsageManForm umForm = (UsageManForm) form;
			
			ValidationUtils.notEmpty("Grants", umForm.getSelectedUsageInfo().getUsageData().getGrants());
			
			IUsageManagementService ums = ServiceFactory.getUsageManagementService(dbID);
			UsageInfo sui = umForm.getSelectedUsageInfo();
			ums.saveUsageData(ui, sui);
			
			umForm.setReference(null);
			umForm.setReferenceId(null);
			
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("saveUsage", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}
	
	public ActionForward addRef(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> addRef");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			UsageManForm umForm = (UsageManForm) form;
			
			String reference = umForm.getReference();
			String refIdType = umForm.getRefIdTypeSelector().getSelectedRefIdType();
			String referenceId = umForm.getReferenceId();
			
			IUsageManagementService ums = ServiceFactory.getUsageManagementService(dbID);
			UsageInfo sui = umForm.getSelectedUsageInfo();
			
	        ValidationUtils.notEmpty("Reference", reference);
	        ValidationUtils.notEmpty("Reference ID", referenceId);
	        
			Publication pub = new Publication();
			pub.setReference(reference);
			pub.setRefIdType(refIdType);
			pub.setRefIdentifier(referenceId);
			
			ums.addPublication(ui, sui, pub);
			
			umForm.setReference(null);
			umForm.setReferenceId(null);
			
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("addRef", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}
	
}
