package clinical.web.actions;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.web.Constants;
import clinical.web.ISubjectVisitManagement;
import clinical.web.ServiceFactory;
import clinical.web.common.UserInfo;
import clinical.web.forms.SubjectVisitManagementForm;
import clinical.web.helpers.SegmentFormInfo;
import clinical.web.helpers.VisitFormInfo;
import clinical.web.vo.PropertyChangeTracker;
import clinical.web.vo.Visit;
import clinical.web.vo.VisitSegment;

/**
 * not used anymore REMOVE (IBO 4/7/2005)
 * 
 * @deprecated
 */
public class VisitManagementAction extends BaseLookupDispatchAction {
	protected Map<String, String> map = new HashMap<String, String>(7);

	protected Map<String, String> getKeyMethodMap() {
		map.put("button.visit_update", "updateVisit");
		map.put("button.visit_add", "addVisit");

		return map;
	}

	public VisitManagementAction() {
	}

	public ActionForward updateVisit(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.debug("*** in update Visit");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
			VisitFormInfo vfi = svmForm.getCurrentVisit();
			PropertyChangeTracker pct = vfi.getPropertyChangeTracker();

			boolean segmentUpdate = false;
			if (!pct.hasChange()) {
				// check if any of the segments has changed
				for (Object element : vfi.getSegmentFormInfos()) {
					SegmentFormInfo sfi = (SegmentFormInfo) element;
					if (sfi.isDirty()) {
						segmentUpdate = true;
					}
				}
				if (!segmentUpdate)
					return mapping.findForward(Constants.SUCCESS);
			}

			// needs update

			ISubjectVisitManagement svm = ServiceFactory
					.getSubjectVisitManagement(dbID);
			Visit v = null;
			if (pct.hasChange()) {
				v = new Visit(vfi.getVisit());
			} else {
				v = new Visit();
			}

			for (Object element : vfi.getSegmentFormInfos()) {
				SegmentFormInfo sfi = (SegmentFormInfo) element;
				if (sfi.isDirty()) {
					VisitSegment vs = new VisitSegment(sfi.getVisitSegment());
					log.debug("updating the visitsegment " + vs.getSegmentID());
					v.addVisitSegment(vs);
					sfi.setDirty(false);
				}
			}

			svm.updateVisitForSubject(ui, v);
			log.debug("finished visit update");
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward addVisit(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.debug("*** in add Visit");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
			VisitFormInfo vfi = svmForm.getCurrentVisit();
			PropertyChangeTracker pct = vfi.getPropertyChangeTracker();

			boolean segmentUpdate = false;
			if (!pct.hasChange()) {
				// check if any of the segments has changed
				for (Object element : vfi.getSegmentFormInfos()) {
					SegmentFormInfo sfi = (SegmentFormInfo) element;
					if (sfi.isDirty()) {
						segmentUpdate = true;
					}
				}
				if (!segmentUpdate)
					return mapping.findForward(Constants.SUCCESS);
			}

			// also add the first segment
			ISubjectVisitManagement svm = ServiceFactory
					.getSubjectVisitManagement(dbID);
			Visit v = null;
			v = new Visit(vfi.getVisit());
			SegmentFormInfo sfi = (SegmentFormInfo) vfi.getSegmentFormInfos()
					.get(0);

			// each segment needs to be on the same as the visit, so set the
			// timestamp from visit
			// and apply changes to the

			sfi.getVisitSegment().setTimeStamp(v.getTs());
			// sfi.applyChanges();
			VisitSegment vs = new VisitSegment(sfi.getVisitSegment());

			vs.setExperimentID(v.getExperimentID());
			vs.setSubjectID(v.getSubjectID());

			v.addVisitSegment(vs);

			svm.addVisitForSubject(ui, v);
			log.debug("finished visit addition");
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

}
