package clinical.web.common.query;

import java.util.*;

import clinical.web.helpers.*;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: DerivedDataQueryBuilder.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class DerivedDataQueryBuilder implements ISearchCriteriaVisitor{
  protected StringBuffer query;

  public DerivedDataQueryBuilder() {}


  public void visit(Operator op) throws Exception {
    StringBuffer inQuery = new StringBuffer(512);
    prepareInnerQuery(inQuery, op);
    query = new StringBuffer(1024);
    prepareQuery(query, inQuery, op);
  }

  public String getQuery() { return query.toString(); }

  protected void prepareQuery(StringBuffer outq,  StringBuffer innerQuery, Operator op) throws Exception {
      if (op instanceof UnaryOperator) {
        UnaryOperator uop = (UnaryOperator) op;
        SearchPredicate sp =  uop.getPredicate();
        Object o = sp.getAttribute();
        if (!(o instanceof SubCorticalVarInfo) )
          throw new Exception("Attribute needs to be of type SubCorticalVarInfo!");
        SubCorticalVarInfo sv = (SubCorticalVarInfo) o;
        outq.append("SELECT DISTINCT SUBJECTID, BRAINREGIONNAME, LATERALITY, MEASUREMENT, COMPONENTID, SEGMENTID, NC_EXPERIMENTID FROM NC_BRAINSEGMENTDATA ");
        outq.append(" WHERE BRAINREGIONNAME='").append( sv.getBrainRegionName() ).append("' AND LATERALITY='");
        outq.append( sv.getLaterality()).append("' AND MEASUREMENTTYPE='").append( sv.getMeasurementType() );
        outq.append("' AND SUBJECTID IN (");
        outq.append( innerQuery);
        outq.append(')');

      } else if (op instanceof BinaryOperator) {
        BinaryOperator bop = (BinaryOperator) op;
        Operator lhs = bop.getLhs();
        prepareQuery(outq, innerQuery, lhs);
        outq.append("\nUNION ALL\n");
        Operator rhs = bop.getRhs();
        prepareQuery(outq, innerQuery, rhs);

      }
    }

    protected void prepareInnerQuery(StringBuffer inq, Operator op)  throws Exception {
      if (op instanceof UnaryOperator) {
      UnaryOperator uop = (UnaryOperator) op;
      SearchPredicate sp =  uop.getPredicate();
      Object o = sp.getAttribute();
        if (!(o instanceof SubCorticalVarInfo) )
          throw new Exception("Attribute needs to be of type SubCorticalVarInfo!");
        SubCorticalVarInfo sv = (SubCorticalVarInfo) o;

      inq.append("SELECT SUBJECTID FROM NC_BRAINSEGMENTDATA  WHERE BRAINREGIONNAME='");
      inq.append( sv.getBrainRegionName() ).append("' AND LATERALITY='");
      inq.append( sv.getLaterality()).append("' AND MEASUREMENTTYPE='").append( sv.getMeasurementType() ).append("' AND ");
      prepareQueryPart(sp, inq);
    } else if (op instanceof BinaryOperator) {
      BinaryOperator bop = (BinaryOperator) op;
      Operator lhs = bop.getLhs();
      prepareInnerQuery(inq, lhs);
      int connective = bop.getLogicalOp();
      if (connective == Operator.AND) {
        inq.append("\nINTERSECT\n");
      } else if (connective == Operator.OR) {
        inq.append("\nUNION\n");
      }
      Operator rhs = bop.getRhs();
      prepareInnerQuery(inq, rhs);
    }

    }

    protected void prepareQueryPart(SearchPredicate sp, StringBuffer inq) throws Exception {

      if (sp.getValue() instanceof SearchPredicate.Range) {
        SearchPredicate.Range range = (SearchPredicate.Range) sp.getValue();
        inq.append("MEASUREMENT BETWEEN ").append(range.getLowBound());
        inq.append(" AND ").append( range.getUppBound());
      } else  {
        inq.append( createPredicate( sp.getValue(), sp.getOperator()) );
      }
      // inq.append(')');
    }


  protected String createPredicate(Object value, int opType)  throws Exception {
    StringBuffer buf = new StringBuffer(64);
    boolean done = false;
    buf.append("MEASUREMENT");

    if (value instanceof String && ( (String) value).equals("*") ) {
      buf.append(" IS NOT NULL ");
      return buf.toString();
    }

    switch(opType) {
      case SearchPredicate.EQUAL:
        buf.append(" = ");
        if (value instanceof String) {
          buf.append("'").append((String) value).append("' ");
        } else if (value instanceof Number) {
          buf.append((Number) value).append(' ');
        } else
           throw new Exception("Not an supported value type:"+ value.getClass().getName());
         done = true;
         break;
       case SearchPredicate.LESS:
         buf.append(" < "); break;
       case SearchPredicate.GREATER:
         buf.append(" > "); break;
       case SearchPredicate.LESS_EQUAL:
         buf.append(" <= "); break;
       case SearchPredicate.GREATER_EQUAL:
         buf.append(" >= "); break;
       case SearchPredicate.NOT_EQUAL:
         buf.append(" <> "); break;
       case SearchPredicate.STARTS_WITH:
         if ( ! (value instanceof String) )
           throw new Exception("Only varchar type can be used with Starts_With comparator!");
         buf.append(" LIKE '").append( (String) value).append("%' ");
         done = true;
         break;
       case SearchPredicate.ENDS_WITH:
         if ( ! (value instanceof String) )
           throw new Exception("Only varchar type can be used with Ends_With comparator!");
         buf.append(" LIKE '%").append( (String) value).append("' ");
         done = true;
         break;
       case SearchPredicate.ANY:
         if ( ! (value instanceof String) )
           throw new Exception("Only varchar type can be used with Any comparator!");
         StringTokenizer stok = new StringTokenizer( (String) value, " ,");
         buf.append(" IN(");
         while( stok.hasMoreTokens() ) {
            buf.append("'").append(stok.nextToken()).append("'");
            if (stok.hasMoreTokens())
              buf.append(',');
         }
         buf.append(") ");
         done = true;
         break;
     }

     if (!done) {
       if ( !(value instanceof Number) )
         throw new Exception("Only numeric type can be used with comparison operators!");
       buf.append((Number) value).append(' ');
     }
     return buf.toString();
  }


  public static void main(String[] args) {

    SubCorticalVarInfo sv1 = new SubCorticalVarInfo("Thalamus", "left","volume","mm^3");
    SubCorticalVarInfo sv2 = new SubCorticalVarInfo("Brain-Stem", "n/a","volume","mm^3");

    //SearchPredicate.Range range = new SearchPredicate.Range(new Integer(15) , new Integer(25) );

    // prepare Operator tree
    UnaryOperator lhs = new UnaryOperator(
        new SearchPredicate(sv1,
                            new Float(0) , SearchPredicate.GREATER_EQUAL, SearchPredicate.FLOAT),
        Operator.NONE);

    UnaryOperator rhs = new UnaryOperator(
          new SearchPredicate(sv2, new Float(0), SearchPredicate.GREATER, SearchPredicate.FLOAT),
          Operator.NONE);
    BinaryOperator bop = new BinaryOperator(lhs, rhs, Operator.AND);

    DerivedDataQueryBuilder qb = new DerivedDataQueryBuilder();
    try {
      qb.visit(bop);
      System.out.println("query=" + qb.getQuery());
    } catch(Exception x) {
      x.printStackTrace();
    }
  }
}