package clinical.web.common.query;

import java.util.Collection;

import org.apache.struts.util.LabelValueBean;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.web.common.vo.TupleQueryInfo;

/**
 * Measurement group query part info.
 * 
 * @author I. Burak Ozyurt
 * @version $Id: MGQueryPartInfo.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class MGQueryPartInfo extends AbstractQueryPartInfo {
	protected TupleQueryInfo tqi;
	protected String connector;
	public final static String NONE = "NONE";
	public final static String AND = "AND";
	public final static String OR = "OR";

	private static final long serialVersionUID = -8205619031967033094L;

	public MGQueryPartInfo(TupleQueryInfo tqi) {
		this.tqi = tqi;
		prepareLogicalOps();
	}
	
	public MGQueryPartInfo(MGQueryPartInfo other) {
		super(other);
		this.tqi = new TupleQueryInfo(other.tqi);
		this.connector = other.connector;
		prepareLogicalOps();		
	}

	private void prepareLogicalOps() throws RuntimeException {
		String varType = getVarType();
		if (varType.equals("integer") || varType.equals("float")
				|| varType.equals("timestamp")) {
			prepareNumericLogicalOps();
		} else if (varType.equals("varchar")) {
			prepareVarcharLogicalOps();
		} else {
			throw new RuntimeException(varType + " is not a supported type!");
		}
	}

	// to fool buggy Struts bean tags
	public Collection<LabelValueBean> getLogicalOps() {
		return super.getLogicalOps();
	}

	@Override
	public Collection<LabelValueBean> getRhsEnums() {
		return rhsEnums;
	}

	public String getMgName() {
		return tqi.getMeasGroupName();
	}

	/**
	 * tupleColumn name
	 * 
	 * @return
	 */
	public String getVarName() {
		// or tqi.getCtdi().getColumName();
		return tqi.getMeasGroupFieldName();
	}

	/**
	 * tupleColumn type
	 * 
	 * @return
	 */
	public String getVarType() {
		return tqi.getCtdi().getColumnType();
	}

	public int getExtTupleID() {
		return tqi.getCtdi().getExtendedTupleID().intValue();
	}

	public TupleQueryInfo getTqi() {
		return tqi;
	}

	public String getConnector() {
		return connector;
	}

	public void setConnector(String connector) {
		this.connector = connector;
	}

	public JSONObject toJSON(JSONObject js) throws JSONException {
		super.toJSON(js);
		js.put("connector", connector);
		js.put("tqi", tqi.toJSON(new JSONObject()));
		/*
		 * js.put("rhs", rhs); js.put("lowBound", lowBound); js.put("uppBound",
		 * uppBound); js.put("operator", operator);
		 */
		return js;
	}

	public static MGQueryPartInfo initializeFromJSON(JSONObject js)
			throws JSONException {
		TupleQueryInfo tqi = TupleQueryInfo.initializeFromJSON(js
				.getJSONObject("tqi"));
		MGQueryPartInfo m = new MGQueryPartInfo(tqi);
		m.connector = js.getString("connector");
		m.rhs = js.getString("rhs");
		if (js.has("lowBound"))
			m.lowBound = js.getString("lowBound");
		if (js.has("uppBound"))
			m.uppBound = js.getString("uppBound");
		m.operator = js.getInt("operator");
		return m;
	}

}
