package clinical.web.common.query;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Types;

import clinical.server.utils.OracleUtils;

public class OracleQueryProcessor extends AbstractQueryProcessor {

	public OracleQueryProcessor(Class<?> valueObjectClass,
			SearchPredicateList spList) throws Exception {
		super(valueObjectClass, spList);
	}

	/**
	 * getTableName
	 * 
	 * @return String
	 */
	protected String getTableName() {
		return "NC_" + getBaseClassName(voClass.getName()).toUpperCase();
	}

	/**
	 * invokeSetter
	 * 
	 * @param m
	 *            Method
	 * @param vo
	 *            Object
	 * @param value
	 *            Object
	 * @param colType
	 */
	protected void invokeSetter(Method m, Object vo, Object value, int colType)
			throws SQLException, InvocationTargetException,
			IllegalArgumentException, IllegalAccessException {

		if (value != null && value instanceof oracle.sql.TIMESTAMP) {
			m.invoke(vo, new Object[] { ((oracle.sql.TIMESTAMP) value)
					.timestampValue() });

		} else if (value != null && colType == Types.CLOB) {
			String s = OracleUtils.readCLOB((oracle.sql.CLOB) value);
			m.invoke(vo, new Object[] { s });
		} else if (value != null && m.getParameterTypes()[0] == Boolean.class
				&& value instanceof BigDecimal) {
			boolean bv = ((BigDecimal) value).intValue() > 0;
			m.invoke(vo, new Object[] { new Boolean(bv) });
		} else {
			try {
				m.invoke(vo, new Object[] { value });
			} catch (Throwable t) {
				System.out.println("value=" + value + " m.paramType="
						+ m.getParameterTypes()[0].getName() + " m=" + m);
				throw new IllegalArgumentException(t);
			}
		}
	}

	protected void preparePredicateDateValue(SearchPredicate sp,
			StringBuffer buf) {
		Date date = (Date) sp.getValue();
		buf.append(df.format(date)).append(' ');
	}

}
