package clinical.web.common.query;

import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import clinical.web.ISQLDialect;
import clinical.web.vo.JobProvenanceInfo.JobProvenanceParamInfo;

public class ProvenanceQueryBuilder extends AbstractQueryBuilder implements
		ISearchCriteriaVisitor {
	// private Map<String, JobProvParamType> paramTypeMap = new HashMap<String,
	// JobProvParamType>();
	private List<Integer> experimentIDs;
	private StringBuilder query;
	private ISQLDialect sqlDialect;
	private static Log log = LogFactory.getLog(ProvenanceQueryBuilder.class);

	public ProvenanceQueryBuilder(ISQLDialect sqlDialect,
			List<Integer> experimentIDs) {
		this.sqlDialect = sqlDialect;
		this.experimentIDs = experimentIDs;
		/*
		 * for (JobProvParamType jppt : provParamTypeList) {
		 * paramTypeMap.put(jppt.getName(), jppt); }
		 */
	}

	public String getQuery() {
		return query.toString();
	}

	@Override
	public void visit(Operator op) throws Exception {
		StringBuilder inQuery = new StringBuilder(768);
		prepareInnerQuery(inQuery, op);
		this.query = new StringBuilder(1024);
		prepareOuterQuery(query, inQuery.toString(), op);
	}

	protected String getOuterStaticPart(String provParamName) {
		StringBuilder buf = new StringBuilder(256);
		buf.append("select c.subjectid, a.value, a.name,");
		buf.append("b.job_uniqueid, c.exp_id, c.component_id ");
		buf.append("from nc_job_provenance_param a,");
		buf.append("nc_job_provenance b, nc_visit_job c ");
		buf.append("where a.job_prov_id = b.uniqueid and ");
		buf.append("b.job_uniqueid = c.job_unique_id and ");
		buf.append("a.name=");
		buf.append(sqlDialect.prepareString(provParamName));
		buf.append(" and a.uniqueid in (");
		return buf.toString();
	}

	protected void prepareOuterQuery(StringBuilder outq, String innerQuery,
			Operator op) throws Exception {
		if (op instanceof UnaryOperator) {
			UnaryOperator uop = (UnaryOperator) op;
			SearchPredicate sp = uop.getPredicate();
			Object o = sp.getAttribute();
			if (!(o instanceof JobProvenanceParamInfo)) {
				throw new RuntimeException(
						"Attribute needs to be of type JobProvenanceParamInfo");
			}
			JobProvenanceParamInfo jppi = (JobProvenanceParamInfo) o;
			outq.append(getOuterStaticPart(jppi.getName()));
			outq.append(innerQuery);
			outq.append(')');
		} else if (op instanceof BinaryOperator) {
			BinaryOperator bop = (BinaryOperator) op;
			Operator lhs = bop.getLhs();
			prepareOuterQuery(outq, innerQuery, lhs);
			Operator rhs = bop.getRhs();
			if (rhs != null) {
				outq.append("\nUNION ALL\n");
				log.debug("rhs=" + rhs);
				prepareOuterQuery(outq, innerQuery, rhs);
			}
		}

	}

	void prepareInnerQuery(StringBuilder inq, Operator op) throws Exception {
		if (op instanceof UnaryOperator) {
			UnaryOperator uop = (UnaryOperator) op;
			SearchPredicate sp = uop.getPredicate();
			prepareQueryPart(sp, inq);
		} else if (op instanceof BinaryOperator) {
			BinaryOperator bop = (BinaryOperator) op;
			Operator lhs = bop.getLhs();
			prepareInnerQuery(inq, lhs);
			int connective = bop.getLogicalOp();
			if (connective == Operator.AND) {
				inq.append("\nINTERSECT\n");
			} else if (connective == Operator.OR) {
				inq.append("\nUNION\n");
			}
			Operator rhs = bop.getRhs();
			prepareInnerQuery(inq, rhs);
		}
	}

	protected void prepareQueryPart(SearchPredicate sp, StringBuilder inq)
			throws Exception {
		Object o = sp.getAttribute();
		if (!(o instanceof JobProvenanceParamInfo)) {
			throw new RuntimeException(
					"Attribute needs to be of type JobProvenanceParamInfo");
		}
		JobProvenanceParamInfo jppi = (JobProvenanceParamInfo) o;
		inq.append(getInnerStaticPart());
		inq.append(" and (a.name=");
		inq.append(sqlDialect.prepareString(jppi.getName())).append(" and ");
		if (sp.getValue() instanceof SearchPredicate.Range) {
			SearchPredicate.Range range = (SearchPredicate.Range) sp.getValue();
			inq.append("a.value between ").append(range.getLowBound());
			inq.append(" and ").append(range.getUppBound());
		} else {
			inq.append(createPredicate("a.value", sp.getValue(),
					sp.getOperator(), sp.getType(), CastingOption.CAST_TO_NUM));
		}
		inq.append(')');
	}

	protected String getInnerStaticPart() {
		StringBuilder buf = new StringBuilder(256);
		// ONLY works with UNION set operator -- secondary filtering of the
		// result sets is necessary
		buf.append("select a.uniqueid from nc_job_provenance_param a,");
		buf.append("nc_job_provenance b, nc_visit_job c where ");
		buf.append("a.job_prov_id = b.uniqueid and ");
		buf.append("b.job_uniqueid = c.job_unique_id ");
		buf.append(prepareExperimentQueryPart());
		return buf.toString();
	}

	protected String prepareExperimentQueryPart() {
		if (experimentIDs == null || experimentIDs.isEmpty()) {
			return "";
		}
		StringBuilder buf = new StringBuilder(80);
		buf.append(" and ");
		if (experimentIDs.size() == 1) {
			buf.append("c.exp_id = ").append((Integer) experimentIDs.get(0));
			buf.append(' ');
		} else {
			buf.append("c.exp_id in (");
			for (Iterator<Integer> iter = experimentIDs.iterator(); iter
					.hasNext();) {
				Integer experimentID = iter.next();
				buf.append(experimentID);
				if (iter.hasNext())
					buf.append(',');
			}
			buf.append(") ");
		}
		return buf.toString();
	}

}
