package clinical.web.common.vo;

import java.math.BigDecimal;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author I. Burak Ozyurt
 * @version $Id: CommonTupleDataInfo.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class CommonTupleDataInfo {
   String columnName;
   String columnType;
   BigDecimal extendedTupleID;
   BigDecimal baseTableID;
   BigDecimal baseTupleID;
   BigDecimal storedTupleID;
   BigDecimal dbUserID;
   String comments;

   public CommonTupleDataInfo(BigDecimal storedTupleID, BigDecimal dbUserID,
         BigDecimal extendedTupleID) {
      this.storedTupleID = storedTupleID;
      this.dbUserID = dbUserID;
      this.extendedTupleID = extendedTupleID;
   }
   
   public CommonTupleDataInfo(CommonTupleDataInfo other) {
	   this.columnName = other.columnName;
	   this.columnType = other.columnType;
	   this.extendedTupleID = other.extendedTupleID;
	   this.baseTableID = other.baseTableID;
	   this.baseTupleID = other.baseTupleID;
	   this.storedTupleID = other.storedTupleID;
	   this.dbUserID = other.dbUserID;
	   this.comments = other.comments;
   }

   public CommonTupleDataInfo() {
   }

   public String getColumnName() {
      return columnName;
   }

   public String getColumnType() {
      return columnType;
   }

   public BigDecimal getExtendedTupleID() {
      return extendedTupleID;
   }

   public BigDecimal getBaseTableID() {
      return baseTableID;
   }

   public BigDecimal getBaseTupleID() {
      return baseTupleID;
   }

   public String getComments() {
      return comments;
   }

   public void setColumnName(String columnName) {
      this.columnName = columnName;
   }

   public void setColumnType(String columnType) {
      this.columnType = columnType;
   }

   public void setComments(String comments) {
      this.comments = comments;
   }

   public BigDecimal getStoredTupleID() {
      return storedTupleID;
   }

   public BigDecimal getDbUserID() {
      return dbUserID;
   }

   public JSONObject toJSON(JSONObject js) throws JSONException {
      js.put("columnName", columnName);
      js.put("columnType", columnType);
      js.put("extendedTupleID", extendedTupleID.intValue());
      return js;
   }

   public static CommonTupleDataInfo initializeFromJSON(JSONObject js)
         throws JSONException {
      CommonTupleDataInfo ctdi = new CommonTupleDataInfo();
      ctdi.columnName = js.getString("columnName");
      ctdi.columnType = js.getString("columnType");
      ctdi.extendedTupleID = new BigDecimal(js.getString("extendedTupleID"));
      return ctdi;
   }

public void setExtendedTupleID(BigDecimal extendedTupleID) {
	this.extendedTupleID = extendedTupleID;
}
}