package clinical.web.download;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import clinical.utils.FileUtils;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */

public class Unzipper {
	protected File destDir;
	protected String zipArchiveFile;
	protected Log log = LogFactory.getLog(Unzipper.class);

	public Unzipper(String zipFile, File destDir) {
		this.destDir = destDir;
		this.zipArchiveFile = zipFile;
	}

	public void unpack() throws ZipException, IOException {
		ZipFile zipFile = new ZipFile(new File(this.zipArchiveFile));
		byte[] buffer = new byte[4096];
		try {
			for (Enumeration<? extends ZipEntry> iter = zipFile.entries(); iter
					.hasMoreElements();) {
				ZipEntry ze = iter.nextElement();
				File outPath = createOutFile(ze.getName(), destDir);
				if (ze.isDirectory()) {
					if (!outPath.mkdirs()) {
						log.error("cannot create directory:" + outPath);
						throw new IOException("Cannot create directory!");
					}
				} else {
					unzipFile(zipFile, ze, outPath, buffer);
				}
			}
		} finally {
			if (zipFile != null) {
				zipFile.close();
			}
		}
	}

	private File createOutFile(String relPath, File outRoot) {
		if (relPath.endsWith("/")) {
			relPath = relPath.substring(0, relPath.length() - 1);
		}
		return new File(outRoot, relPath);
	}

	private void unzipFile(ZipFile zipFile, ZipEntry ze, File outFile,
			byte[] buffer) throws IOException {
		if (!outFile.getParentFile().exists()) {
			File dir = outFile.getParentFile();
			if (!dir.mkdirs()) {
				log.error("cannot create directory:" + dir);
				throw new IOException("Cannot create directory!");
			}
		}
		BufferedInputStream bin = null;
		BufferedOutputStream bout = null;
		try {
			bin = new BufferedInputStream(zipFile.getInputStream(ze), 4096);
			bout = new BufferedOutputStream(new FileOutputStream(outFile), 4096);
			int bytesRead = -1;
			while ((bytesRead = bin.read(buffer)) > 0) {
				bout.write(buffer, 0, bytesRead);
			}
		} finally {
			FileUtils.close(bin);
			FileUtils.close(bout);
		}
	}
}
