package clinical.web.forms;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.struts.action.ActionForm;

import clinical.web.common.security.DBConfig;
import clinical.web.common.security.Privilege;
import clinical.web.common.security.User;
import clinical.web.helpers.DbUserSelector;
import clinical.web.helpers.WebUserSelector;
import clinical.web.vo.ExperimentInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: UserManForm.java 385 2011-07-07 00:24:25Z bozyurt $
 */
public class UserManForm extends ActionForm {
	protected DBConfig curDBConfig;
	protected List<Privilege> privileges;
	protected List<ExperimentInfo> curDBExperiments;
	protected Map<String, InviteInfo> inviteMap = new HashMap<String, InviteInfo>(
			7);
	protected Map<String, UserProjectPrivMatrixMan> ppMatrixManMap = new HashMap<String, UserProjectPrivMatrixMan>(
			17);
	/** current database id */
	protected String curDB;
	protected String masterUser;
	/**
	 * scratch variable used to indicate the name of the current web user for
	 * subsequent calls to the form object
	 */
	protected String curWebUser;
	protected String opType = ADD_OP;

	protected WebUser newUser;
	protected WebUserSelector webUserSelector;

	public final static String ADD_OP = "add";
	public final static String EDIT_OP = "edit";
	private static final long serialVersionUID = 1L;

	public DBConfig getCurDBConfig() {
		return curDBConfig;
	}

	public void setCurDBConfig(DBConfig curDBConfig) {
		this.curDBConfig = curDBConfig;
	}

	public List<User> getWebUsers() {
		return this.curDBConfig.getWebUsers();
	}
	
	public List<Privilege> getPrivileges() {
		return privileges;
	}

	public void setPrivileges(List<Privilege> privileges) {
		this.privileges = privileges;
	}

	public List<ExperimentInfo> getCurDBExperiments() {
		return curDBExperiments;
	}

	public void setCurDBExperiments(List<ExperimentInfo> curDBExperiments) {
		this.curDBExperiments = curDBExperiments;
	}

	public String getCurDB() {
		return curDB;
	}

	public void setCurDB(String curDB) {
		this.curDB = curDB;
	}

	public String getCurWebUser() {
		return curWebUser;
	}

	public void setCurWebUser(String curWebUser) {
		this.curWebUser = curWebUser;
	}

	public String getOpType() {
		return opType;
	}

	public void setOpType(String opType) {
		this.opType = opType;
	}

	public Map<String, UserProjectPrivMatrixMan> getPpMatrixManMap() {
		List<User> webUsers = curDBConfig.getWebUsers();
		for (User webUser : webUsers) {
			String name = webUser.getName();
			UserProjectPrivMatrixMan uppMan = new UserProjectPrivMatrixMan(
					curDBExperiments, webUser);
			ppMatrixManMap.put(name, uppMan);
		}

		return ppMatrixManMap;
	}

	public static class WebUser implements Serializable {
		protected String userName;
		protected String password;
		protected String passwordRepeat;
		protected String email;

		protected DbUserSelector dbUserSelector;
		protected DBConfig dbConfig;
		private static final long serialVersionUID = 1L;

		public String getUserName() {
			return userName;
		}

		public void setUserName(String userName) {
			this.userName = userName;
		}

		public String getPassword() {
			return password;
		}

		public void setPassword(String password) {
			this.password = password;
		}

		public String getPasswordRepeat() {
			return passwordRepeat;
		}

		public void setPasswordRepeat(String passwordRepeat) {
			this.passwordRepeat = passwordRepeat;
		}

		public DbUserSelector getDbUserSelector() {
			return dbUserSelector;
		}

		public void setDbUserSelector(DbUserSelector dbUserSelector) {
			this.dbUserSelector = dbUserSelector;
		}

		public String getEmail() {
			return email;
		}

		public void setEmail(String email) {
			this.email = email;
		}

	}

	public WebUser getNewUser() {
		return newUser;
	}

	public void setNewUser(WebUser newUser) {
		this.newUser = newUser;
	}

	public String getMasterUser() {
		return masterUser;
	}

	public void setMasterUser(String masterUser) {
		this.masterUser = masterUser;
	}

	public static class InviteInfo {
		boolean canEmail = false;
		String message;
		boolean hasError = false;

		public InviteInfo() {
		}

		public boolean isCanEmail() {
			return canEmail;
		}

		public void setCanEmail(boolean canEmail) {
			this.canEmail = canEmail;
		}

		public String getMessage() {
			return message;
		}

		public void setMessage(String message) {
			this.message = message;
		}

		public boolean isHasError() {
			return hasError;
		}

		public void setHasError(boolean hasError) {
			this.hasError = hasError;
		}
	}

	public Map<String, InviteInfo> getInviteMap() {
		return inviteMap;
	}

	public WebUserSelector getWebUserSelector() {
		return webUserSelector;
	}

	public void setWebUserSelector(WebUserSelector webUserSelector) {
		this.webUserSelector = webUserSelector;
	}

}
