package clinical.web.game;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.StringTokenizer;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

import clinical.server.vo.Dataclassification;
import clinical.server.vo.Storedassessment;
import clinical.utils.DateTimeUtils;
import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.web.DBUtils;
import clinical.web.IAssessmentService;
import clinical.web.ISubjectAssessmentManagement;
import clinical.web.ServiceFactory;
import clinical.web.UserContainer;
import clinical.web.actions.BaseLookupDispatchAction;
import clinical.web.common.IDBCache;
import clinical.web.common.UserInfo;
import clinical.web.exception.BaseException;
import clinical.web.exception.GAMEException;
import clinical.web.forms.SubjectVisitManagementForm;
import clinical.web.helpers.SubjectManagementHelper;
import clinical.web.vo.AssessmentInfo;
import clinical.web.vo.AssessmentScoreValues;
import clinical.web.vo.ScoreValue;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: AssessmentManagementAction.java,v 1.39 2007/10/10 01:11:40
 *          bozyurt Exp $
 */

public class AssessmentManagementAction extends BaseLookupDispatchAction {
   protected Map<String, String> map = new HashMap<String, String>(7);

   protected static final SimpleDateFormat df = new SimpleDateFormat(
         "MM/dd/yyyy");

   protected static final SimpleDateFormat tf = new SimpleDateFormat("HH:mm");

   public AssessmentManagementAction() {
      logger = LogFactory.getLog(AssessmentManagementAction.class);
   }

 
   protected Map<String,String> getKeyMethodMap() {
      map.put("button.next", "nextForm");
      map.put("button.previous", "prevForm");
      map.put("action.form.display", "showForm");
      map.put("action.form.submit", "submitForm");
      map.put("action.form.add", "addAnswer");
      map.put("action.form.removeLast", "deleteAnswer");
      map.put("action.form.skip", "skipQuestions");
      return map;
   }

   public ActionForward prevForm(ActionMapping mapping, ActionForm form,
         HttpServletRequest request, HttpServletResponse response)
         throws Exception {
      try {
         HttpSession session = request.getSession(false);
         UserContainer uc = (UserContainer) session
               .getAttribute(Constants.CONTAINER_KEY);

         UserInfo ui = uc.getUserInfo();
         return handlePrevForm(mapping, form, request, response, ui);
      } catch (Throwable t) {
         return handleExceptions(mapping, form, request, response, t);
      }
   }

   protected ActionForward handlePrevForm(ActionMapping mapping,
         ActionForm form, HttpServletRequest request,
         HttpServletResponse response, UserInfo ui) throws Exception {
      AssessmentManagementHelper amh = AssessmentManagementHelper
            .getInstance("clinical.web.game.forms");
      int pageNumber = ((Integer) amh.getFormProperty(
            Constants.CURRENTPAGEIDX_PROPERTY, form, form.getClass()))
            .intValue();
      HttpSession session = request.getSession(false);
      // set fields for the previous page
      setFormDataForPage(pageNumber - 1, form, request, session, ui);
      amh.setFormProperty(Constants.CURRENTPAGEIDX_PROPERTY, form, form
            .getClass(), new Integer(pageNumber - 1));
      return mapping.findForward(Constants.PREVIOUS);
   }

   public ActionForward nextForm(ActionMapping mapping, ActionForm form,
         HttpServletRequest request, HttpServletResponse response)
         throws Exception {
      try {
         HttpSession session = request.getSession(false);
         UserContainer uc = (UserContainer) session
               .getAttribute(Constants.CONTAINER_KEY);
         UserInfo ui = uc.getUserInfo();

         return handleNextForm(mapping, form, request, ui);
      } catch (Throwable t) {
         return handleExceptions(mapping, form, request, response, t);
      }
   }

   protected ActionForward handleNextForm(ActionMapping mapping,
         ActionForm form, HttpServletRequest request, UserInfo ui)
         throws Exception {
      AssessmentManagementHelper amh = AssessmentManagementHelper
            .getInstance("clinical.web.game.forms");

      int pageNumber = ((Integer) amh.getFormProperty(
            Constants.CURRENTPAGEIDX_PROPERTY, form, form.getClass()))
            .intValue();
      HttpSession session = request.getSession(false);
      Map<String, Map<String, String>> dbVarMetaDataMap = new HashMap<String, Map<String, String>>(
            23);
      ActionMessages errors = validate(pageNumber, form, amh, dbVarMetaDataMap);
      if (!errors.isEmpty()) {
         prepareValidationErrors(request, errors);
         return mapping.findForward(Constants.FAILURE);
      }
      // submit the content of the current page
      submitPage(pageNumber, form, request, session, ui, dbVarMetaDataMap);
      // set the fields for the next page
      setFormDataForPage(pageNumber + 1, form, request, session, ui);
      amh.setFormProperty(Constants.CURRENTPAGEIDX_PROPERTY, form, form
            .getClass(), new Integer(pageNumber + 1));
      return mapping.findForward(Constants.NEXT);
   }

   public ActionForward skipQuestions(ActionMapping mapping, ActionForm form,
         HttpServletRequest request, HttpServletResponse response)
         throws Exception {
      try {
         HttpSession session = request.getSession(false);
         UserContainer uc = (UserContainer) session
               .getAttribute(Constants.CONTAINER_KEY);
         UserInfo ui = uc.getUserInfo();
         String dbID = (String) session
               .getAttribute(Constants.SESSION_DBID_KEY);

         Class<? extends ActionForm> formClazz = form.getClass();
         AssessmentManagementHelper amh = AssessmentManagementHelper
               .getInstance("clinical.web.game.forms");

         String skipReason = (String) amh.getFormProperty(
               "dataClassificationForSkipped", form, formClazz);
         String qidStr = (String) amh.getFormProperty("skippedQuestions", form,
               formClazz);
         List<Comparable<Integer>> qidList = GenUtils.extractList(qidStr, ",", Integer.class);
         Set<?> pageNumbers = amh.getPagesAffected(qidList, formClazz);

         handleSkipSection(request, form, pageNumbers, qidList, dbID, ui,
               skipReason);

         return mapping.findForward(Constants.SUCCESS);
      } catch (Throwable t) {
         return handleExceptions(mapping, form, request, response, t);
      }
   }

   public ActionForward addAnswer(ActionMapping mapping, ActionForm form,
         HttpServletRequest request, HttpServletResponse response)
         throws Exception {
      try {
         log.info("********** in addAnswer");
         System.out.println("********** in addAnswer");
         HttpSession session = request.getSession(false);
         UserContainer uc = (UserContainer) session
               .getAttribute(Constants.CONTAINER_KEY);
         uc.getUserInfo();
         Class<? extends ActionForm> formClazz = form.getClass();
         AssessmentManagementHelper amh = AssessmentManagementHelper
               .getInstance("clinical.web.game.forms");
         Integer pageNumber = (Integer) amh.getFormProperty(
               Constants.CURRENTPAGEIDX_PROPERTY, form, formClazz);

         String selectedQuestion = (String) amh.getFormProperty(
               Constants.SELECTEDQUESTION_PROPERTY, form, formClazz);

         System.out.println("*********** Selected question:" + selectedQuestion
               + " pageNumber:" + pageNumber);
         if (selectedQuestion != null && selectedQuestion.length() > 0) {
            int selQuestID = Integer.parseInt(selectedQuestion);
            Map<Integer, List<String>> dbVarNamesPerPage = amh
                  .getDataVarNamesPerPage(form.getClass());
            List<String> dbVarNames = dbVarNamesPerPage.get(pageNumber);

            Map<String, PageQuestionInfo> dbVar2PqiMap = amh
                  .prepareDbVar2PageQuestionInfoMap(pageNumber.intValue(),
                        form, formClazz, dbVarNames);
            System.out.println("dbVar2PqiMap:" + dbVar2PqiMap.size());
            for (Map.Entry<String, PageQuestionInfo> entry : dbVar2PqiMap
                  .entrySet()) {
               PageQuestionInfo pqi = entry.getValue();
               String dbVarName = entry.getKey();
               System.out.println("pqi.getQuestionNumber():"
                     + pqi.getQuestionNumber());
               if (pqi.getQuestionNumber() == selQuestID) {
                  Integer size = (Integer) amh.runMethod(pageNumber.intValue(),
                        dbVarName, AssessmentManagementHelper.SIZE_METHOD,
                        null, form, formClazz);
                  if (size.intValue() >= pqi.getMaxAnswer()) {
                     System.out.println("don't grow beyond the max answer:"
                           + pqi.getMaxAnswer());
                     // don't grow beyond the max answer
                     break;
                  }
                  for (String scoreName : pqi.getScoreNames()) {
                     // add an empty item
                     Object defaultValue = amh.prepareDefaultValue(form,
                           formClazz, pageNumber, scoreName);

                     amh.runMethod(pageNumber.intValue(), scoreName,
                           AssessmentManagementHelper.ADD_METHOD,
                           new Object[]{defaultValue}, form, formClazz);
                  }
                  break;
               }
            }
         }

         return mapping.findForward(Constants.SUCCESS);
      } catch (Throwable t) {
         return handleExceptions(mapping, form, request, response, t);
      }
   }

   public ActionForward deleteAnswer(ActionMapping mapping, ActionForm form,
         HttpServletRequest request, HttpServletResponse response)
         throws Exception {
      try {
         System.out.println("*************** in deleteAnswer");
         UserInfo ui = getUserInfo(request);
         HttpSession session = request.getSession(false);

         Class<? extends ActionForm> formClazz = form.getClass();

         AssessmentManagementHelper amh = AssessmentManagementHelper
               .getInstance("clinical.web.game.forms");

         Integer pageNumber = (Integer) amh.getFormProperty(
               Constants.CURRENTPAGEIDX_PROPERTY, form, formClazz);

         String selectedQuestion = (String) amh.getFormProperty(
               Constants.SELECTEDQUESTION_PROPERTY, form, formClazz);
         if (selectedQuestion != null && selectedQuestion.length() > 0) {
            int selQuestID = Integer.parseInt(selectedQuestion);
            Map<Integer, List<String>> dbVarNamesPerPage = amh
                  .getDataVarNamesPerPage(form.getClass());
            List<String> dbVarNames = dbVarNamesPerPage.get(pageNumber);

            List<String> dbVars4Pqi = new ArrayList<String>(5);
            PageQuestionInfo selPqi = null;
            int idx2Delete = -1;
            Map<String, PageQuestionInfo> dbVar2PqiMap = amh
                  .prepareDbVar2PageQuestionInfoMap(pageNumber.intValue(),
                        form, formClazz, dbVarNames);
            boolean first = true;
            for (Map.Entry<String, PageQuestionInfo> entry : dbVar2PqiMap
                  .entrySet()) {
               PageQuestionInfo pqi = (PageQuestionInfo) entry.getValue();
               String dbVarName = (String) entry.getKey();
               if (pqi.getQuestionNumber() == selQuestID) {
                  Integer size = (Integer) amh.runMethod(pageNumber.intValue(),
                        dbVarName, AssessmentManagementHelper.SIZE_METHOD,
                        null, form, formClazz);
                  if (size.intValue() <= 1) {
                     break;
                  }
                  if (first) {
                     for (String scoreName : pqi.getScoreNames()) {
                        amh.runMethod(pageNumber.intValue(), scoreName,
                              AssessmentManagementHelper.REMOVE_LAST_METHOD,
                              new Object[0], form, formClazz);
                     }
                     first = false;
                  }
                  dbVars4Pqi.add(dbVarName);
                  idx2Delete = size.intValue() - 1;
                  selPqi = pqi;
               }
            }// iter
            if (selPqi != null) {
               // also delete from the database

               String dbID = (String) session
                     .getAttribute(Constants.SESSION_DBID_KEY);
               AsSegmentInfo asgi = getAssessmentSegmentInfo(amh, form, request);

               IAssessmentService ias = ServiceFactory
                     .getAssessmentService(dbID);

               AssessmentInfo theAsi = ias.getAssessmentWithScores(ui,
                     asgi.assessmentID);
               assert (theAsi != null);
               AssessmentScoreValues asv = new AssessmentScoreValues(theAsi);
               asv.setExperimentID(asgi.experimentID);
               asv.setSegmentID(asgi.segmentID);
               asv.setSubjectID(asgi.subjectID);
               asv.setVisitID(asgi.visitID);
               List<ScoreValue> scoreValues = new ArrayList<ScoreValue>(
                     dbVars4Pqi.size());
               for (Iterator<String> iter = dbVars4Pqi.iterator(); iter
                     .hasNext();) {
                  String dbVarName = iter.next();
                  ScoreValue sv = new ScoreValue(dbVarName, null,
                        idx2Delete + 1);
                  scoreValues.add(sv);
               }
               SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) session
                     .getAttribute(Constants.SVMFORM_KEY);
               int entryID = getSelectedEntryID(svmForm);

               ISubjectAssessmentManagement isam = ServiceFactory
                     .getSubjectAssessmentManagement(dbID);
               isam.deleteScoreValues(dbID, ui, asv, scoreValues, entryID);
            }
         }

         return mapping.findForward(Constants.SUCCESS);
      } catch (Throwable t) {
         return handleExceptions(mapping, form, request, response, t);
      }
   }

   private void prepareValidationErrors(HttpServletRequest request,
         ActionMessages errors) {
      super.saveErrors(request, errors);
   }

   /*
    * private static void dumpMapKeys(Map map, String dbVarName) { for (Iterator
    * iter = map.keySet().iterator(); iter.hasNext();) { Object key = (Object)
    * iter.next(); if ( key.equals(dbVarName)) { System.out.println(">>>key
    * matches dbVarName " + dbVarName); } System.out.println("mapKey key=" + key + " " +
    * map.get(key)); } }
    */
   private ActionMessages validate(int pageNumber, ActionForm form,
         AssessmentManagementHelper amh,
         Map<String, Map<String, String>> dbVarMetaDataMap) throws Exception {
      ActionMessages errors = new ActionMessages();
      Map<Integer, List<String>> dbVarNamesPerPage = amh
            .getDataVarNamesPerPage(form.getClass());
      List<String> dbVarNames = dbVarNamesPerPage.get(new Integer(pageNumber));
      if (dbVarNames == null) {
         // for cover page without any scores
         return errors;
      }
      Class<? extends ActionForm> formClazz = form.getClass();
      Map<String, PageQuestionInfo> dbVar2PqiMap = amh
            .prepareDbVar2PageQuestionInfoMap(pageNumber, form, formClazz,
                  dbVarNames);
      for (String dbVarName : dbVarNames) {

         PageQuestionInfo pqi = dbVar2PqiMap.get(dbVarName);

         Map<String, String> metaDataMap = amh.getPropertyMetaData(pageNumber,
               dbVarName, form, formClazz);
         if (metaDataMap != null) {
            dbVarMetaDataMap.put(dbVarName, metaDataMap);
         }
         String formVarName = amh.getFormBeanVariableName(pageNumber,
               dbVarName, formClazz);

         if (pqi != null && pqi.isMultiAnswer()) {
            Integer size = (Integer) amh
                  .runMethod(pageNumber, dbVarName,
                        AssessmentManagementHelper.SIZE_METHOD, null, form,
                        formClazz);
            if (metaDataMap != null) {
               Integer scoreID = (Integer) pqi.getIDForScoreName(dbVarName);
               for (int i = 0; i < size.intValue(); i++) {
                  Object value = amh.getProperty(pageNumber, dbVarName, i,
                        form, formClazz);
                  String tsFormat = metaDataMap.get("format");
                  if (tsFormat != null) {
                     /** @todo check handle unaswered questions!! */
                     boolean hasNotes = AssessmentManagementHelper.hasNotes(pqi
                           .getQuestionNumber(), i + 1, scoreID.intValue(),
                           form, formClazz, amh);

                     validateTimestamp(errors, formVarName, value, tsFormat,
                           hasNotes);
                  }
               }
            }
         } else { // single answer
            if (pqi != null) {
               if (metaDataMap != null) {
                  Object value = amh.getProperty(pageNumber, dbVarName, -1,
                        form, formClazz);
                  // for any timestamp validation
                  String tsFormat = metaDataMap.get("format");
                  if (tsFormat != null) {
                     boolean hasNotes = AssessmentManagementHelper.hasNotes(pqi
                           .getQuestionNumber(), -1, form, formClazz, amh);
                     validateTimestamp(errors, formVarName, value, tsFormat,
                           hasNotes);
                  }
               }
            }
         }
      }

      return errors;
   }

   private void validateTimestamp(ActionMessages errors, String formVarName,
         Object value, String tsFormat, boolean hasNotes) {
      if (!hasNotes) {

         try {
            SimpleDateFormat df = new SimpleDateFormat(tsFormat);
            df.setLenient(false);
            df.parse(value.toString());
         } catch (ParseException pe) {
            errors.add(ActionMessages.GLOBAL_MESSAGE, new ActionMessage(
                  "errors.invalid.timestamp.format", formVarName, tsFormat,
                  value));
         }
      }
   }

   private AsSegmentInfo getAssessmentSegmentInfo(
         AssessmentManagementHelper amh, ActionForm form,
         HttpServletRequest request) throws Exception {
      AsSegmentInfo asgi = new AsSegmentInfo();
      asgi.assessmentID = getAssessmentID(amh, request, form);
      asgi.subjectID = getSubjectID(amh, request, form);
      asgi.experimentID = getExperimentID(amh, request, form);
      asgi.visitID = getVisitID(amh, request, form);
      asgi.segmentID = getSegmentID(amh, request, form);

      log.info("SubjectID= " + asgi.subjectID + " assessmentID="
            + asgi.assessmentID);
      log.info("*** visitID=" + asgi.visitID + " segmentID= " + asgi.segmentID);

      return asgi;
   }

   static class AsSegmentInfo {
      int assessmentID;
      String subjectID;
      int experimentID;
      int visitID;
      int segmentID;
      public AsSegmentInfo() {
      }
   }

   protected void setFormDataForPage(int pageNumber, ActionForm form,
         HttpServletRequest request, HttpSession session, UserInfo userInfo)
         throws Exception {

      AssessmentManagementHelper amh = AssessmentManagementHelper
            .getInstance("clinical.web.game.forms");

      String dbID = (String) session.getAttribute(Constants.SESSION_DBID_KEY);
      ISubjectAssessmentManagement isam = ServiceFactory
            .getSubjectAssessmentManagement(dbID);

      IDBCache dbCache = ServiceFactory.getDBCache(dbID);
      List<Dataclassification> dataClassifications = dbCache
            .getDataClassications(userInfo, false);

      AsSegmentInfo asgi = getAssessmentSegmentInfo(amh, form, request);

      Class<? extends ActionForm> formClazz = form.getClass();
      log.info("formClazz=" + formClazz);

      List<String> dbVarNames = amh.getDataVariableNames(pageNumber, formClazz);
      if (dbVarNames.isEmpty()) {
         // nothing to set for this JSP's form
         return;
      }

      IAssessmentService ias = ServiceFactory.getAssessmentService(dbID);
      AssessmentInfo theAsi = ias.getAssessmentWithScores(userInfo,
            asgi.assessmentID);

      if (theAsi == null) {
         throw new Exception("The assessment  was not found in the database!");
      }

      SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) session
            .getAttribute(Constants.SVMFORM_KEY);

      int entryID = getSelectedEntryID(svmForm);

      List<AssessmentInfo> asInfos = new ArrayList<AssessmentInfo>(1);
      asInfos.add(theAsi);

      List<AssessmentScoreValues> scoreValues = isam
            .getAssessmentValuesForSubject(userInfo, asgi.subjectID,
                  asgi.experimentID, asgi.visitID, asgi.segmentID, asInfos,
                  entryID, false);

      if (scoreValues != null && !scoreValues.isEmpty()) {

         // populate the form bean
         AssessmentScoreValues asv = scoreValues.get(0);

         if (log.isDebugEnabled()) {
            asv.dumpScoreInfos();
         }

         Map<String, PageQuestionInfo> dbVar2PqiMap = amh
               .prepareDbVar2PageQuestionInfoMap(pageNumber, form, formClazz,
                     dbVarNames);

         for (String dbVarName : dbVarNames) {
            PageQuestionInfo pqi = dbVar2PqiMap
                  .get(dbVarName);

            // the variables corresponding to the viewed form are set in the
            // form bean
            if (pqi != null && pqi.isMultiAnswer()) {
               int scoreID = ((Integer) pqi.getIDForScoreName(dbVarName))
                     .intValue();
               Integer size = (Integer) amh.runMethod(pageNumber, dbVarName,
                     AssessmentManagementHelper.SIZE_METHOD, null, form,
                     formClazz);

               for (int i = 0; i < pqi.getMaxAnswer(); i++) {
                  ScoreValue scoreValue = asv.getScoreValue(dbVarName, i + 1);
                  if (scoreValue != null && scoreValue.getValue() != null) {
                     AssessmentInfo.ScoreInfo si = theAsi.findScore(scoreValue
                           .getName());
                     if (i >= size.intValue()) {
                        Object defaultValue = amh.prepareDefaultValue(form,
                              formClazz, new Integer(pageNumber), dbVarName);
                        amh.runMethod(pageNumber, dbVarName,
                              AssessmentManagementHelper.ADD_METHOD,
                              new Object[]{defaultValue}, form, formClazz);
                     }
                     amh.setProperty(pageNumber, dbVarName, form, formClazz,
                           scoreValue.getValue(), si.getType(), i);

                     // set the hidden form field for
                     // dataClassification also
                     AssessmentManagementHelper
                           .setDataClassificationHiddenFormField(form, amh,
                                 dataClassifications, formClazz, scoreValue,
                                 pqi, i + 1, scoreID);
                  }
               }
            } else {
               // single valued
               ScoreValue scoreValue = asv.getScoreValue(dbVarName, 1);
               if (scoreValue != null && scoreValue.getValue() != null) {
                  AssessmentInfo.ScoreInfo si = theAsi.findScore(scoreValue
                        .getName());
                  amh.setProperty(pageNumber, dbVarName, form, formClazz,
                        scoreValue.getValue(), si.getType(), -1);

                  // set the hidden form field for dataClassification also
                  if (pqi != null) {
                     AssessmentManagementHelper
                           .setDataClassificationHiddenFormField(form, amh,
                                 dataClassifications, formClazz, scoreValue,
                                 pqi, -1, -1);
                  }
               }
            }
         } // iter

         AssessmentManagementHelper.setMandatoryFormInfo(dbID, form, userInfo,
               amh, isam, asgi.subjectID, asgi.experimentID, asgi.visitID,
               asgi.segmentID, theAsi, asv);
      }
   }

   protected void handleSkipSection(HttpServletRequest request,
         ActionForm form, Set<?> pageNumbers, List<?> questionIDs, String dbID,
         UserInfo userInfo, String skipReason) throws Exception {
      AssessmentManagementHelper amh = AssessmentManagementHelper
            .getInstance("clinical.web.game.forms");
      AsSegmentInfo asgi = getAssessmentSegmentInfo(amh, form, request);
      Class<? extends ActionForm> formClazz = form.getClass();
      IAssessmentService ias = ServiceFactory.getAssessmentService(dbID);
      AssessmentInfo theAsi = ias.getAssessmentWithScores(userInfo,
            asgi.assessmentID);
      if (theAsi == null) {
         throw new Exception("The assessment  was not found in the database!");
      }

      HttpSession session = request.getSession(false);
      SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) session
            .getAttribute(Constants.SVMFORM_KEY);
      int entryID = getSelectedEntryID(svmForm);

      List<AssessmentInfo> asInfos = new ArrayList<AssessmentInfo>(1);
      asInfos.add(theAsi);

      ISubjectAssessmentManagement isam = ServiceFactory
            .getSubjectAssessmentManagement(dbID);

      List<AssessmentScoreValues> scoreValues = isam
            .getAssessmentValuesForSubject(userInfo, asgi.subjectID,
                  asgi.experimentID, asgi.visitID, asgi.segmentID, asInfos,
                  entryID, false);

      IDBCache dbCache = ServiceFactory.getDBCache(dbID);
      List<Dataclassification> dataClassifications = dbCache
            .getDataClassications(userInfo, false);

      int curPageNumber = ((Integer) amh.getFormProperty(
            Constants.CURRENTPAGEIDX_PROPERTY, form, form.getClass()))
            .intValue();

      for (Iterator<?> iter = pageNumbers.iterator(); iter.hasNext();) {
         int pageNumber = ((Integer) iter.next()).intValue();
         Map<String, Map<String, String>> dbVarMetaDataMap = new HashMap<String, Map<String, String>>(
               23);

         // submit the current page , for other affected pages only
         // insert/update
         // skipped sections

         if (pageNumber == curPageNumber) {
            submitPage(pageNumber, form, request, session, userInfo,
                  dbVarMetaDataMap);
            continue;
         }

         // only get skipped variables
         List<String> dbVarNames = amh.getDataVariableNames(pageNumber,
               formClazz, questionIDs);
         if (dbVarNames.isEmpty()) {
            continue;
         }

         // for the questions to be skipped for this page set reason to skip
         AssessmentManagementHelper.setNoteForQuestions(pageNumber, form, amh,
               dbVarNames, skipReason);

         ParameterGroup pg = new ParameterGroup(dataClassifications, dbID,
               dbVarMetaDataMap, dbVarNames, entryID, form, pageNumber,
               userInfo, amh);

         if (scoreValues != null && !scoreValues.isEmpty()) {
            // update
            UpdateInformation updateInfo = new UpdateInformation();

            updateScoreValues(pg, scoreValues, isam, updateInfo, true);
         } else {
            // insert
            // first create and populate an AssessmentScoreValues object
            AssessmentScoreValues asv = new AssessmentScoreValues(theAsi);
            asv.setExperimentID(asgi.experimentID);
            asv.setSegmentID(asgi.segmentID);
            asv.setSubjectID(asgi.subjectID);
            asv.setVisitID(asgi.visitID);

            insertScoreValues(pg, isam, asv, true);
         }
      }

   }

   protected void submitPage(int pageNumber, ActionForm form,
         HttpServletRequest request, HttpSession session, UserInfo userInfo,
         Map<String, Map<String, String>> dbVarMetaDataMap) throws Exception {
      AssessmentManagementHelper amh = AssessmentManagementHelper
            .getInstance("clinical.web.game.forms");

      String dbID = (String) session.getAttribute(Constants.SESSION_DBID_KEY);
      ISubjectAssessmentManagement isam = ServiceFactory
            .getSubjectAssessmentManagement(dbID);

      AsSegmentInfo asgi = getAssessmentSegmentInfo(amh, form, request);

      Class<? extends ActionForm> formClazz = form.getClass();
      log.info("formClazz=" + formClazz);

      List<String> dbVarNames = amh.getDataVariableNames(pageNumber, formClazz);
      if (dbVarNames.isEmpty()) {
         // nothing to set for this JSP's form
         return;
      }

      IAssessmentService ias = ServiceFactory.getAssessmentService(dbID);
      AssessmentInfo theAsi = ias.getAssessmentWithScores(userInfo,
            asgi.assessmentID);

      if (theAsi == null) {
         throw new Exception("The assessment  was not found in the database!");
      }

      SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) session
            .getAttribute(Constants.SVMFORM_KEY);
      int entryID = getSelectedEntryID(svmForm);

      List<AssessmentInfo> asInfos = new ArrayList<AssessmentInfo>(1);
      asInfos.add(theAsi);

      List<AssessmentScoreValues> scoreValues = isam
            .getAssessmentValuesForSubject(userInfo, asgi.subjectID,
                  asgi.experimentID, asgi.visitID, asgi.segmentID, asInfos,
                  entryID, false);

      IDBCache dbCache = ServiceFactory.getDBCache(dbID);
      List<Dataclassification> dataClassifications = dbCache
            .getDataClassications(userInfo, false);

      ParameterGroup pg = new ParameterGroup(dataClassifications, dbID,
            dbVarMetaDataMap, dbVarNames, entryID, form, pageNumber, userInfo,
            amh);

      if (scoreValues != null && !scoreValues.isEmpty()) {
         // update
         UpdateInformation updateInfo = new UpdateInformation();
         updateScoreValues(pg, scoreValues, isam, updateInfo, true);
      } else {
         // insert
         // first create and populate an AssessmentScoreValues object
         AssessmentScoreValues asv = new AssessmentScoreValues(theAsi);
         asv.setExperimentID(asgi.experimentID);
         asv.setSegmentID(asgi.segmentID);
         asv.setSubjectID(asgi.subjectID);
         asv.setVisitID(asgi.visitID);

         insertScoreValues(pg, isam, asv, true);
      }
   }

   protected void updateScoreValues(ParameterGroup pg,
         List<AssessmentScoreValues> scoreValues,
         ISubjectAssessmentManagement isam, UpdateInformation updateInfo,
         boolean applyUpdates) throws Exception {
      // update
      log.info("*** Updating the assessment ");
      Class<? extends ActionForm> formClazz = pg.getForm().getClass();
      ActionForm form = pg.getForm();
      int pageNumber = pg.getPageNumber();
      List<String> dbVarNames = pg.getDbVarNames();
      List<Dataclassification> dataClassifications = pg
            .getDataClassifications();

      AssessmentManagementHelper amh = pg.getAmh();
      // there should be only one asv
      AssessmentScoreValues asv = scoreValues.get(0);

      // set the mandatory fields in asv
      AssessmentManagementHelper.setMandatoryData(pg.getForm(), amh, asv,
            formClazz);

      Map<Integer, String> reasonMap = DBUtils.getMissingValueReasonMap(pg
            .getUserInfo(), pg.getDbID());

      Map<String, PageQuestionInfo> dbVar2PqiMap = amh
            .prepareDbVar2PageQuestionInfoMap(pageNumber, form, formClazz,
                  dbVarNames);

      for (String dbVarName : dbVarNames) {
         PageQuestionInfo pqi = dbVar2PqiMap.get(dbVarName);
         if (pqi == null) {
            log.error("pqi = null dbVarName=" + dbVarName);
         }

         if (pqi != null && pqi.isMultiAnswer()) {
            Integer size = (Integer) amh
                  .runMethod(pageNumber, dbVarName,
                        AssessmentManagementHelper.SIZE_METHOD, null, form,
                        formClazz);
            for (int i = 0; i < size.intValue(); i++) {
               Object value = amh.getProperty(pageNumber, dbVarName, i, form,
                     formClazz);
               ScoreValue sv = asv.getScoreValue(dbVarName, i + 1);
               Integer scoreID = (Integer) pqi.getIDForScoreName(dbVarName);

               // check if there is a note , if so make the value invalid
               // and add note
               boolean hasNotes = AssessmentManagementHelper.hasNotes(pqi
                     .getQuestionNumber(), i + 1, scoreID.intValue(), form,
                     formClazz, amh);

               if (!hasNotes && AssessmentManagementHelper.isValueValid(value)) {
                  log.info("** valid value=" + value);

                  if (sv == null) {
                     sv = new ScoreValue(dbVarName, value.toString(), i + 1);
                     asv.addScoreValue(sv);
                     updateInfo.scoreValuesToBeAdded.add(sv);
                  } else {
                     if (sv.getValue() == null
                           || !sv.getValue().equals(value.toString())) {
                        sv.setValue(value.toString());
                        if (!updateInfo.scoresToBeUpdated.contains(dbVarName)) {
                           updateInfo.scoresToBeUpdated.add(dbVarName);
                        }
                     }
                  }
               } else {
                  AssessmentManagementHelper.Params params = new AssessmentManagementHelper.Params(
                        dbVarName, form, formClazz, amh);
                  if (sv == null) {
                     AssessmentManagementHelper.handleNotes(params, pqi
                           .getQuestionNumber(), i + 1, scoreID.intValue(),
                           asv, dataClassifications,
                           updateInfo.scoreValuesToBeAdded, null, reasonMap);
                  } else {
                     // update ScoreValues' notes
                     AssessmentManagementHelper.handleNotes4Updates(params, pqi
                           .getQuestionNumber(), i + 1, scoreID.intValue(),
                           asv, dataClassifications,
                           updateInfo.scoresToBeUpdated, sv, reasonMap);
                  }
                  log.warn("No value for dbVarName=" + dbVarName);
               }
            }
         } else { // single answer question
            Object value = amh.getProperty(pageNumber, dbVarName, -1, form,
                  formClazz);

            ScoreValue sv = asv.getScoreValue(dbVarName, 1);

            log.info("updateScoreValues: value=" + value + " scoreValue sv="
                  + sv);

            // check if there is a note , if so make the value invalid and
            // add note
            boolean hasNotes = false;
            if (pqi != null) {
               hasNotes = AssessmentManagementHelper.hasNotes(pqi
                     .getQuestionNumber(), -1, form, formClazz, amh);
            }

            if (!hasNotes && AssessmentManagementHelper.isValueValid(value)) {
               if (sv == null) {
                  log.info("dbVarName " + dbVarName
                        + " does not have a score value!");
                  sv = new ScoreValue(dbVarName, value.toString(), 1);
                  asv.addScoreValue(sv);
                  updateInfo.scoreValuesToBeAdded.add(sv);
               } else if (sv.getValue() == null
                     || !sv.getValue().equals(value.toString())) {
                  sv.setValue(value.toString());
                  updateInfo.scoresToBeUpdated.add(dbVarName);
               }
            } else if (hasNotes) {
               if (pqi != null) {
                  AssessmentManagementHelper.Params params = new AssessmentManagementHelper.Params(
                        dbVarName, form, formClazz, amh);
                  if (sv == null) {
                     AssessmentManagementHelper.handleNotes(params, pqi
                           .getQuestionNumber(), -1, -1, asv,
                           dataClassifications,
                           updateInfo.scoreValuesToBeAdded, null, reasonMap);
                  } else {
                     // update ScoreValues' notes
                     AssessmentManagementHelper.handleNotes4Updates(params, pqi
                           .getQuestionNumber(), -1, -1, asv,
                           dataClassifications, updateInfo.scoresToBeUpdated,
                           sv, reasonMap);
                  }
               }
            } else { // !isValueValid(value) && !hasNotes
               // do nothing
               // ::CHECK
            } // isValueValid
         }
         // log.info("formVar "+ formVarName + " parameter value=" +
         // request.getParameter(formVarName) );
      } // for dbVarnames
      if (applyUpdates) {
         applyUpdate(pg.getDbID(), pg.getUserInfo(), updateInfo, isam, asv, pg
               .getEntryID(), pg.getDbVarMetaDataMap());
      }
   }

   protected void applyUpdate(String dbID, UserInfo userInfo,
         UpdateInformation updateInfo, ISubjectAssessmentManagement isam,
         AssessmentScoreValues asv, int entryID,
         Map<String, Map<String, String>> dbVarMetaDataMap) throws Exception {
      log.info("updating asv (affected number of scores: "
            + updateInfo.scoresToBeUpdated.size() + ")");
      isam.updateAssessmentValues(userInfo, dbID, asv,
            updateInfo.scoresToBeUpdated, entryID, dbVarMetaDataMap);
      if (!updateInfo.scoreValuesToBeAdded.isEmpty()) {
         if (entryID >= 1) {
            isam.insertScoreValues(dbID, userInfo, asv,
                  updateInfo.scoreValuesToBeAdded, GenUtils
                        .toBigDecimal(entryID), false, dbVarMetaDataMap);
         } else {
            isam.insertScoreValues(dbID, userInfo, asv,
                  updateInfo.scoreValuesToBeAdded, dbVarMetaDataMap);
         }
      }
   }

   //FIXME type safety
   class UpdateInformation {
      List<String> scoresToBeUpdated;
      // for multi-answer questions
      List<ScoreValue> scoreValuesToBeAdded;

      public UpdateInformation() {
         scoresToBeUpdated = new LinkedList<String>();
         scoreValuesToBeAdded = new LinkedList<ScoreValue>();
      }
   }

   protected void insertScoreValues(ParameterGroup pg,
         ISubjectAssessmentManagement isam, AssessmentScoreValues asv,
         boolean applyInsert) throws Exception {
      ActionForm form = pg.getForm();
      int pageNumber = pg.getPageNumber();
      AssessmentManagementHelper amh = pg.getAmh();
      List<String> dbVarNames = pg.getDbVarNames();
      String dbID = pg.getDbID();
      UserInfo userInfo = pg.getUserInfo();

      Class<? extends ActionForm> formClazz = form.getClass();
      AssessmentManagementHelper.setMandatoryData(form, amh, asv, formClazz);

      Map<String,PageQuestionInfo> dbVar2PqiMap = amh.prepareDbVar2PageQuestionInfoMap(pageNumber, form,
            formClazz, dbVarNames);

      Map<Integer,String> reasonMap = DBUtils.getMissingValueReasonMap(userInfo, dbID);

      for (String dbVarName : dbVarNames) {
         PageQuestionInfo pqi = dbVar2PqiMap.get(dbVarName);

         AssessmentManagementHelper.Params params = new AssessmentManagementHelper.Params(
               dbVarName, form, formClazz, amh);
         AssessmentManagementHelper.addScoreValue(pqi, asv, pg
               .getDataClassifications(), pageNumber, params, reasonMap);
      }

      if (applyInsert) {
         applyInsertScoreValues(dbID, userInfo, isam, asv, pg.getEntryID(), pg
               .getDbVarMetaDataMap());
      }
   }

   protected void applyInsertScoreValues(String dbID, UserInfo userInfo,
         ISubjectAssessmentManagement isam, AssessmentScoreValues asv,
         int entryID, Map<String, Map<String, String>> dbVarMetaDataMap) throws Exception {
      log.info("inserting asv ");
      if (entryID >= 1) {
         isam.insertAssessmentValues(userInfo, dbID, asv, GenUtils
               .toBigDecimal(entryID), false, dbVarMetaDataMap);
      } else {
         isam.insertAssessmentValues(userInfo, dbID, asv, dbVarMetaDataMap);
      }
   }

   protected int getSelectedEntryID(SubjectVisitManagementForm svmForm) {
      if (svmForm.getSelectedEntryID() == null
            || svmForm.getSelectedEntryID().trim().length() == 0) {
         // return the first entry
         return 1;
      }
      int entryID = Integer.parseInt(svmForm.getSelectedEntryID());
      if (entryID == -1) {
         log.info("*** getSelectedEntryID:" + entryID);
         entryID = 1;
      }
      return entryID;
   }

   public ActionForward showForm(ActionMapping mapping, ActionForm form,
         HttpServletRequest request, HttpServletResponse response)
         throws Exception {
      try {
         log.info("in showForm");
         UserInfo userInfo = getUserInfo(request);
         HttpSession session = request.getSession(false);

         AssessmentManagementHelper amh = AssessmentManagementHelper
               .getInstance("clinical.web.game.forms");

         String dbID = (String) session
               .getAttribute(Constants.SESSION_DBID_KEY);

         Class<? extends ActionForm> formClazz = form.getClass();
         log.info("formClazz=" + formClazz);

         IDBCache dbCache = ServiceFactory.getDBCache(dbID);
         List<Dataclassification> dataClassifications = dbCache
               .getDataClassications(userInfo, false);

         AsSegmentInfo asgi = getAssessmentSegmentInfo(amh, form, request);

         // subjectID, visitID, segmentID, experimentID
         // find the corresponding form and populate if there is an
         // assessment for this segment
         ISubjectAssessmentManagement isam = ServiceFactory
               .getSubjectAssessmentManagement(dbID);

         int pageNumber = ((Integer) amh.getFormProperty(
               Constants.CURRENTPAGEIDX_PROPERTY, form, formClazz)).intValue();

         IAssessmentService ias = ServiceFactory.getAssessmentService(dbID);
         AssessmentInfo theAsi = ias.getAssessmentWithScores(userInfo,
               asgi.assessmentID);

         if (theAsi == null) {
            return mapping.findForward(Constants.FAILURE);
         }

         SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) session
               .getAttribute(Constants.SVMFORM_KEY);
         int entryID = getSelectedEntryID(svmForm);

         List<AssessmentInfo> asInfos = new ArrayList<AssessmentInfo>(1);
         asInfos.add(theAsi);
         logger.info("entryID=" + entryID);
         List<AssessmentScoreValues> scoreValues = isam.getAssessmentValuesForSubject(userInfo,
               asgi.subjectID, asgi.experimentID, asgi.visitID, asgi.segmentID,
               asInfos, entryID, false);

         if (scoreValues != null && !scoreValues.isEmpty()) {
            // populate the form bean
            AssessmentScoreValues asv = scoreValues
                  .get(0);

            // set informant info
            List<Storedassessment> saList = isam.getStoredAssessmentRecs(dbID, userInfo,
                  asgi.subjectID, asgi.experimentID, asgi.visitID,
                  asgi.segmentID, theAsi.getAssessmentID());
            Storedassessment sa = saList.get(0);

            amh.setFormProperty(Constants.INFORMANTID_PROPERTY, form,
                  formClazz, sa.getInformantid());
            amh.setFormProperty(Constants.INFORMANTRELATION_PROPERTY, form,
                  formClazz, sa.getInformantrelation());

            if (amh.hasFormProperty(Constants.CLINICALRATER_PROPERTY, form,
                  form.getClass())) {
               amh
                     .prepareClinicalRaterProperty(form, userInfo, formClazz,
                           isam);
            }

            if (log.isDebugEnabled()) {
               asv.dumpScoreInfos();
            }

            List<String> dbVarNames = amh.getDataVariableNames(pageNumber, formClazz);
            Map<String,PageQuestionInfo> dbVar2PqiMap = amh.prepareDbVar2PageQuestionInfoMap(pageNumber,
                  form, formClazz, dbVarNames);

            for (String dbVarName : dbVarNames) {
               // the variables corresponding to the viewed form are set in
               // the form bean
               ScoreValue scoreValue = null;

               PageQuestionInfo pqi = dbVar2PqiMap
                     .get(dbVarName);

               if (pqi != null && pqi.isMultiAnswer()) {
                  Integer size = (Integer) amh.runMethod(pageNumber, dbVarName,
                        AssessmentManagementHelper.SIZE_METHOD, null, form,
                        formClazz);

                  int scoreID = ((Integer) pqi.getIDForScoreName(dbVarName))
                        .intValue();
                  for (int i = 0; i < pqi.getMaxAnswer(); i++) {
                     scoreValue = asv.getScoreValue(dbVarName, i + 1);
                     if (scoreValue != null && scoreValue.getValue() != null) {
                        AssessmentInfo.ScoreInfo si = theAsi
                              .findScore(scoreValue.getName());
                        if (i >= size.intValue()) {
                           Object defaultValue = amh.prepareDefaultValue(form,
                                 formClazz, new Integer(pageNumber), dbVarName);
                           amh.runMethod(pageNumber, dbVarName,
                                 AssessmentManagementHelper.ADD_METHOD,
                                 new Object[]{defaultValue}, form, formClazz);
                        }
                        amh
                              .setProperty(pageNumber, dbVarName, form,
                                    formClazz,
                                    scoreValue.getUncorrectedValue(), si
                                          .getType(), i);

                        // set the hidden form field for
                        // dataClassification also
                        AssessmentManagementHelper
                              .setDataClassificationHiddenFormField(form, amh,
                                    dataClassifications, formClazz, scoreValue,
                                    pqi, i + 1, scoreID);
                     }
                  }
               } else {
                  scoreValue = asv.getScoreValue(dbVarName, 1);
                  if (scoreValue != null && scoreValue.getValue() != null) {
                     AssessmentInfo.ScoreInfo si = theAsi.findScore(scoreValue
                           .getName());

                     amh.setProperty(pageNumber, dbVarName, form, formClazz,
                           scoreValue.getUncorrectedValue(), si.getType(), -1);

                     // set the hidden form field for dataClassification
                     // also
                     if (pqi != null) {
                        AssessmentManagementHelper
                              .setDataClassificationHiddenFormField(form, amh,
                                    dataClassifications, formClazz, scoreValue,
                                    pqi, -1, -1);
                     }
                  }
               }
            } // iter
            Date tsmp = asv.getTimeStamp();
            amh.setFormProperty(Constants.TIME_PROPERTY, form, form.getClass(),
                  tf.format(tsmp));
            amh.setFormProperty(Constants.DATE_PROPERTY, form, form.getClass(),
                  df.format(tsmp));

         } else {
            // set informant id and informantrelation to defaults
            amh.setFormProperty(Constants.INFORMANTID_PROPERTY, form, form
                  .getClass(), asgi.subjectID);
            amh.setFormProperty(Constants.INFORMANTRELATION_PROPERTY, form,
                  form.getClass(), Constants.SELF);

            // also use the segment date and time as defaults
            Timestamp tstamp = isam.getSegmentTimeStamp(dbID, userInfo,
                  asgi.subjectID, asgi.experimentID, asgi.visitID,
                  asgi.segmentID);
            String fs = DateTimeUtils.formatTimestamp(tstamp);
            if (fs != null) {
               StringTokenizer stok = new StringTokenizer(fs);
               String dateStr = stok.nextToken();
               String timeStr = stok.nextToken();
               amh.setFormProperty(Constants.TIME_PROPERTY, form, form
                     .getClass(), timeStr);
               amh.setFormProperty(Constants.DATE_PROPERTY, form, form
                     .getClass(), dateStr);
            }

         }
         return mapping.findForward(Constants.SUCCESS);
      } catch (Throwable t) {
         return handleExceptions(mapping, form, request, response, t);
      }
   }

   public ActionForward submitForm(ActionMapping mapping, ActionForm form,
         HttpServletRequest request, HttpServletResponse response)
         throws Exception {
      try {
         log.info("in submitForm");
         UserInfo userInfo = getUserInfo(request);
         HttpSession session = request.getSession(false);

         String dbID = (String) session
               .getAttribute(Constants.SESSION_DBID_KEY);

         SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) session
               .getAttribute(Constants.SVMFORM_KEY);

         IDBCache dbCache = ServiceFactory.getDBCache(dbID);
         AssessmentManagementHelper amh = AssessmentManagementHelper
               .getInstance("clinical.web.game.forms");

         Class<? extends ActionForm> formClazz = form.getClass();

         List<Dataclassification> dataClassifications = dbCache
               .getDataClassications(userInfo, false);

         AsSegmentInfo asgi = getAssessmentSegmentInfo(amh, form, request);

         IAssessmentService ias = ServiceFactory.getAssessmentService(dbID);
         AssessmentInfo asi = ias.getAssessmentWithScores(userInfo,
               asgi.assessmentID);

         ISubjectAssessmentManagement isam = ServiceFactory
               .getSubjectAssessmentManagement(dbID);

         if (asi == null) {
            return mapping.findForward(Constants.FAILURE);
         }

         int entryID = getSelectedEntryID(svmForm);

         List<AssessmentInfo> asInfos = new ArrayList<AssessmentInfo>(1);
         asInfos.add(asi);

         List<AssessmentScoreValues> scoreValues = isam
               .getAssessmentValuesForSubject(userInfo, asgi.subjectID,
                     asgi.experimentID, asgi.visitID, asgi.segmentID, asInfos,
                     entryID, false);

         Map<Integer,List<String>> dbVarNamesPerPage = amh.getDataVarNamesPerPage(formClazz);
         Map<String, Map<String, String>> dbVarMetaDataMap = new HashMap<String, Map<String, String>>();

         if (scoreValues != null && !scoreValues.isEmpty()) {
            // update
            UpdateInformation updateInfo = new UpdateInformation();

            for (Iterator<Entry<Integer, List<String>>> iter = dbVarNamesPerPage.entrySet().iterator(); iter
                  .hasNext();) {
               Entry<Integer, List<String>> entry = iter.next();
               int pageNum = entry.getKey().intValue();
               List<String> dbVarNames = entry.getValue();

               ActionMessages errors = validate(pageNum, form, amh,
                     dbVarMetaDataMap);
               if (!errors.isEmpty()) {
                  prepareValidationErrors(request, errors);
                  return mapping.findForward(Constants.FAILURE);
               }

               ParameterGroup pg = new ParameterGroup(dataClassifications,
                     dbID, dbVarMetaDataMap, dbVarNames, entryID, form,
                     pageNum, userInfo, amh);

               updateScoreValues(pg, scoreValues, isam, updateInfo, false);

            }
            // there should be only one asv
            AssessmentScoreValues asv = scoreValues.get(0);
            // now update every page at once
            applyUpdate(dbID, userInfo, updateInfo, isam, asv, entryID,
                  dbVarMetaDataMap);

         } else {
            // insert
            // first create and populate an AssessmentScoreValues object
            AssessmentScoreValues asv = new AssessmentScoreValues(asi);
            asv.setExperimentID(asgi.experimentID);
            asv.setSegmentID(asgi.segmentID);
            asv.setSubjectID(asgi.subjectID);
            asv.setVisitID(asgi.visitID);

            for (Iterator<Entry<Integer, List<String>>> iter = dbVarNamesPerPage.entrySet().iterator(); iter
                  .hasNext();) {
               Entry<Integer, List<String>> entry = iter.next();
               int pageNum = ((Integer) entry.getKey()).intValue();
               List<String> dbVarNames = (List<String>) entry.getValue();
               ParameterGroup pg = new ParameterGroup(dataClassifications,
                     dbID, dbVarMetaDataMap, dbVarNames, entryID, form,
                     pageNum, userInfo, amh);

               insertScoreValues(pg, isam, asv, false);

               // do validation before any database update
               ActionMessages errors = validate(pageNum, form, amh,
                     dbVarMetaDataMap);
               if (!errors.isEmpty()) {
                  prepareValidationErrors(request, errors);
                  return mapping.findForward(Constants.FAILURE);
               }
            }

            // now insert scores from all pages at once
            applyInsertScoreValues(dbID, userInfo, isam, asv, entryID,
                  dbVarMetaDataMap);
         }

         svmForm.setSelectedEntryID("-1");

         SubjectManagementHelper.prepareForSegmentManPage(session, userInfo,
               dbID, svmForm, asgi.subjectID, asgi.experimentID,
               asgi.segmentID, 1, SubjectManagementHelper.RETRIEVE_BOTH, false);

         log.info("FORWARDING back...");
         return mapping.findForward(Constants.BACK);
      } catch (Throwable t) {
         t.printStackTrace();
         return handleExceptions(mapping, form, request, response, t);
      }
   }

   private ActionForward handleExceptions(ActionMapping mapping,
         ActionForm form, HttpServletRequest request,
         HttpServletResponse response, Throwable t) throws ServletException {
      BaseException x = null;
      if (t instanceof BaseException) {
         x = (BaseException) t;
      } else {
         x = new BaseException(t);
      }
      return processExceptions(request, response, mapping, form, x);
   }

   protected String getParameter(String property, HttpServletRequest request,
         AssessmentManagementHelper amh, ActionForm form) throws GAMEException {
      try {
         String value = request.getParameter(property);
         if (value == null) {
            value = (String) amh.getFormProperty(property, form, form
                  .getClass());
         }
         return value;
      } catch (Exception x) {
         throw new GAMEException(x);
      }
   }

   public AssessmentManagementHelper getAssessmentManagementHelper() {
      return AssessmentManagementHelper.getInstance("clinical.web.game.forms");
   }

   public int getAssessmentID(AssessmentManagementHelper amh,
         HttpServletRequest request, ActionForm form) throws GAMEException {
      int assessmentID = Integer.parseInt(getParameter("assessmentID", request,
            amh, form));
      return assessmentID;
   }

   public int getExperimentID(AssessmentManagementHelper amh,
         HttpServletRequest request, ActionForm form) throws GAMEException {
      return Integer.parseInt(getParameter("experimentID", request, amh, form));
   }

   public int getVisitID(AssessmentManagementHelper amh,
         HttpServletRequest request, ActionForm form) throws GAMEException {
      return Integer.parseInt(getParameter("visitID", request, amh, form));
   }

   public int getSegmentID(AssessmentManagementHelper amh,
         HttpServletRequest request, ActionForm form) throws GAMEException {
      return Integer.parseInt(getParameter("segmentID", request, amh, form));
   }

   public String getSubjectID(AssessmentManagementHelper amh,
         HttpServletRequest request, ActionForm form) throws GAMEException {
      return getParameter("subjectID", request, amh, form);
   }

}
