package clinical.web.game;

import java.util.HashMap;
import java.util.Map;

/**
 * 
 * Represents the mapping of a form variable name with a database variable name
 * and holds the page number of the form this variable is displayed. An
 * assessment form can consist of multiple pages which translate to a single
 * Struts Form bean and to a single JSP per page of the paper assessment form.
 * The pages are numbered starting from 1.
 * 
 * @author I. Burak Ozyurt
 */
public class PageVariableInfo {
	private int pageNumber;
	private String formVarName;
	private String dbVarName;
	private Map<String, String> metaDataMap;

	public PageVariableInfo(int pageNumber, String formVarName, String dbVarName) {
		this.pageNumber = pageNumber;
		this.formVarName = formVarName;
		this.dbVarName = dbVarName;
	}

	public int getPageNumber() {
		return this.pageNumber;
	}

	public String getFormVarName() {
		return this.formVarName;
	}

	public String getDbVarName() {
		return this.dbVarName;
	}

	public void addMetaData(String name, String value) {
		if (metaDataMap == null) {
			metaDataMap = new HashMap<String, String>(3);
		}
		metaDataMap.put(name, value);
	}

	public Map<String, String> getMetaDataMap() {
		return metaDataMap;
	}

	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("PageVariableInfo ::[");
		buf.append("pageNumber=").append(pageNumber).append(", formVarName=");
		buf.append(formVarName).append(", dbVarName=").append(dbVarName);
		buf.append(']');
		return buf.toString();
	}
}