package clinical.web.game.forms;

import java.util.*;
import javax.servlet.http.*;
import java.text.*;

import org.apache.commons.logging.*;
import org.apache.struts.action.*;
import org.apache.struts.util.*;
/**
  *
  * @version $Id: FIGSForm.java 366 2011-05-05 20:06:27Z bozyurt $
  * @author Generated by Clinical Assessment Layout Manager (CALM)
  */

public class FIGSForm extends ActionForm {

    private String figs1= "";
    private String figs2= "";
    private String figs3= "";
    private String figs4= "";
    private String figs5= "";
    private String figs6= "";
    private String figsTotalScore= "";
    private String date = "";
    private String time = "";
    private String informantid = "";
    private String informantrelation = "";
    private DynamicDropDownSelector clinicalrater;

    // variables standard for each generated Assessment Struts Form Bean
    private String assessmentID;
    private String subjectID;
    private String experimentID;
    private String visitID;
    private String segmentID;
    private int currentPageIdx = 1;
    private String selectedQuestion = "";
    private String skippedQuestions = "";
    private String dataClassificationForSkipped = "";

    private static Map pageQuestionsMap;
    private static Map variableMap = null;
    private static Map mandatoryFieldMetaDataMap = null;

    public FIGSForm() {
    }

    public String getFigs1() {  return this.figs1; }
    public String getFigs2() {  return this.figs2; }
    public String getFigs3() {  return this.figs3; }
    public String getFigs4() {  return this.figs4; }
    public String getFigs5() {  return this.figs5; }
    public String getFigs6() {  return this.figs6; }
    public String getFigsTotalScore() {  return this.figsTotalScore; }
    public String getDate() {  return this.date; }
    public String getTime() {  return this.time; }
    public String getInformantid() {  return this.informantid; }
    public String getInformantrelation() {  return this.informantrelation; }
    public DynamicDropDownSelector getClinicalrater() {  return this.clinicalrater; }

    public void setFigs1(String newValue) {  this.figs1 = newValue; }
    public void setFigs2(String newValue) {  this.figs2 = newValue; }
    public void setFigs3(String newValue) {  this.figs3 = newValue; }
    public void setFigs4(String newValue) {  this.figs4 = newValue; }
    public void setFigs5(String newValue) {  this.figs5 = newValue; }
    public void setFigs6(String newValue) {  this.figs6 = newValue; }
    public void setFigsTotalScore(String newValue) {  this.figsTotalScore = newValue; }
    public void setDate(String newValue) {  this.date = newValue; }
    public void setTime(String newValue) {  this.time = newValue; }
    public void setInformantid(String newValue) {  this.informantid = newValue; }
    public void setInformantrelation(String newValue) {  this.informantrelation = newValue; }
    public void setClinicalrater(DynamicDropDownSelector newValue) {  this.clinicalrater = newValue; }

                    
                    
                    


    public String getAssessmentID() {  return this.assessmentID; }
    public String getSubjectID() {  return this.subjectID; }
    public String getExperimentID() {  return this.experimentID; }
    public String getVisitID() {  return this.visitID; }
    public String getSegmentID() {  return this.segmentID; }
    public int getCurrentPageIdx() {  return this.currentPageIdx; }
    public String getSelectedQuestion() {  return this.selectedQuestion; }
    public String getSkippedQuestions() {  return this.skippedQuestions; }
    public String getDataClassificationForSkipped() {  return this.dataClassificationForSkipped; }

    public void setAssessmentID(String newValue) {  this.assessmentID = newValue; }
    public void setSubjectID(String newValue) {  this.subjectID = newValue; }
    public void setExperimentID(String newValue) {  this.experimentID = newValue; }
    public void setVisitID(String newValue) {  this.visitID = newValue; }
    public void setSegmentID(String newValue) {  this.segmentID = newValue; }
    public void setCurrentPageIdx(int newValue) {  this.currentPageIdx = newValue; }
    public void setSelectedQuestion(String newValue) {  this.selectedQuestion = newValue; }
    public void setSkippedQuestions(String newValue) {  this.skippedQuestions = newValue; }
    public void setDataClassificationForSkipped(String newValue) {  this.dataClassificationForSkipped = newValue; }

    
public static class PageVariableInfo {
      int pageNumber;
      String formVarName;
      String dbVarName;
      Map metaDataMap;
      public PageVariableInfo(int pageNumber, String formVarName, String dbVarName) {
        this.pageNumber = pageNumber;
        this.formVarName = formVarName;
        this.dbVarName = dbVarName;
      }

      public int getPageNumber() { return this.pageNumber; }
      public String getFormVarName() { return this.formVarName; }
      public String getDbVarName() { return this.dbVarName; }
      public void addMetaData(String name, String value) {
        if (metaDataMap == null) {
          metaDataMap = new HashMap(3);
        }
        metaDataMap.put(name, value);
      }
      public Map getMetaDataMap() { return metaDataMap; }
    }

    private final static String assessmentName = "Fagerstrom Test for Nicotine Dependence";

    public static String getAssessmentName() { return assessmentName; }

    public static Map getVariableMap() {
      synchronized(FIGSForm.class) {
        if (variableMap == null) {
      variableMap = new LinkedHashMap();
      PageVariableInfo pvi = null;

          variableMap.put("figs1", pvi = new PageVariableInfo(2,"figs1","figs1") );
          variableMap.put("figs2", pvi = new PageVariableInfo(2,"figs2","figs2") );
          variableMap.put("figs3", pvi = new PageVariableInfo(2,"figs3","figs3") );
          variableMap.put("figs4", pvi = new PageVariableInfo(2,"figs4","figs4") );
          variableMap.put("figs5", pvi = new PageVariableInfo(2,"figs5","figs5") );
          variableMap.put("figs6", pvi = new PageVariableInfo(2,"figs6","figs6") );
          variableMap.put("figsTotalScore", pvi = new PageVariableInfo(2,"figsTotalScore","figsTotalScore") );
        }
      }
      return variableMap;
    }
    public static Map getMandatoryFieldMetaDataMap() {
      if (mandatoryFieldMetaDataMap == null) {
        mandatoryFieldMetaDataMap = new HashMap(3);
        Map mdMap = new HashMap(3);
        mandatoryFieldMetaDataMap.put("clinicalrater",mdMap);
        mdMap.put("query","select a.name from nc_databaseuser a, nc_userclass b where a.userclass = b.uniqueid and b.name = 'researcher'");
      }
      return mandatoryFieldMetaDataMap;
    }


 public static class PageQuestionInfo {
    int pageNumber;
    int questionNumber;
    String type;
    int minAnswer;
    int maxAnswer;
    List scoreNames = new LinkedList();
    Map scoreNameIDMAp = new HashMap(3);

    public PageQuestionInfo(int pageNumber, int questionNumber, String type) {
      this(pageNumber, questionNumber, type, 1, 1);
    }

    public PageQuestionInfo(int pageNumber, int questionNumber, String type,
                            int minAnswer, int maxAnswer)
    {
      this.pageNumber = pageNumber;
      this.questionNumber = questionNumber;
      this.type = type;
      this.minAnswer = minAnswer;
      this.maxAnswer = maxAnswer;
    }

    public int getPageNumber() { return pageNumber; }
    public int getQuestionNumber() { return questionNumber; }
    public String getType() { return type; }
    public int getMinAnswer() { return minAnswer; }
    public int getMaxAnswer() { return maxAnswer; }

    public void addScoreNameIDAssoc(String scoreName, int id) {
       scoreNameIDMAp.put(scoreName, new Integer(id));
    }

    public Integer getIDForScoreName(String scoreName) {
       return (Integer) scoreNameIDMAp.get(scoreName);
    }

    public void addScoreName(String scoreName) {
      scoreNames.add(scoreName);
    }

    public List getScoreNames() { return scoreNames; }
  }


    public static Map getPageQuestionsMap() {
      synchronized(FIGSForm.class) {
        if (pageQuestionsMap == null) {
          pageQuestionsMap = new LinkedHashMap();

          List list = null;
          PageQuestionInfo pqi = null;
          list = new LinkedList();
          pageQuestionsMap.put( new Integer(2), list);
          list.add( pqi = new PageQuestionInfo(2,3,"regular") );
          pqi.addScoreName("figs3");
          pqi.addScoreNameIDAssoc("figs3",0);
          list.add( pqi = new PageQuestionInfo(2,7,"regular") );
          pqi.addScoreName("figsTotalScore");
          pqi.addScoreNameIDAssoc("figsTotalScore",0);
          list.add( pqi = new PageQuestionInfo(2,2,"regular") );
          pqi.addScoreName("figs2");
          pqi.addScoreNameIDAssoc("figs2",0);
          list.add( pqi = new PageQuestionInfo(2,1,"regular") );
          pqi.addScoreName("figs1");
          pqi.addScoreNameIDAssoc("figs1",0);
          list.add( pqi = new PageQuestionInfo(2,6,"regular") );
          pqi.addScoreName("figs6");
          pqi.addScoreNameIDAssoc("figs6",0);
          list.add( pqi = new PageQuestionInfo(2,5,"regular") );
          pqi.addScoreName("figs5");
          pqi.addScoreNameIDAssoc("figs5",0);
          list.add( pqi = new PageQuestionInfo(2,4,"regular") );
          pqi.addScoreName("figs4");
          pqi.addScoreNameIDAssoc("figs4",0);
        }
      }
      return pageQuestionsMap;
    }

    private String q3_notes = "";
    private String q7_notes = "";
    private String q2_notes = "";
    private String q1_notes = "";
    private String q6_notes = "";
    private String q5_notes = "";
    private String q4_notes = "";

    public String getQ3_notes() {  return this.q3_notes; }
    public void setQ3_notes(String newValue) {  this.q3_notes = newValue; }
    public String getQ7_notes() {  return this.q7_notes; }
    public void setQ7_notes(String newValue) {  this.q7_notes = newValue; }
    public String getQ2_notes() {  return this.q2_notes; }
    public void setQ2_notes(String newValue) {  this.q2_notes = newValue; }
    public String getQ1_notes() {  return this.q1_notes; }
    public void setQ1_notes(String newValue) {  this.q1_notes = newValue; }
    public String getQ6_notes() {  return this.q6_notes; }
    public void setQ6_notes(String newValue) {  this.q6_notes = newValue; }
    public String getQ5_notes() {  return this.q5_notes; }
    public void setQ5_notes(String newValue) {  this.q5_notes = newValue; }
    public String getQ4_notes() {  return this.q4_notes; }
    public void setQ4_notes(String newValue) {  this.q4_notes = newValue; }
    
    public void reset(ActionMapping mapping, HttpServletRequest request) {
    }
}
