package clinical.web.helpers;

import static clinical.web.CBFBIRNConstants.CASL;
import static clinical.web.CBFBIRNConstants.EMBEDDED_CSF_ASL_SERIES_ARR;
import static clinical.web.CBFBIRNConstants.EPISTAR;
import static clinical.web.CBFBIRNConstants.FAIR;
import static clinical.web.CBFBIRNConstants.OPT_PCASL;
import static clinical.web.CBFBIRNConstants.OPT_PCASL_CALIB;
import static clinical.web.CBFBIRNConstants.PCASL;
import static clinical.web.CBFBIRNConstants.PCASL_4MP;
import static clinical.web.CBFBIRNConstants.PCASL_4MP_or_Opt_PCASL_Calib;
import static clinical.web.CBFBIRNConstants.PCASL_8MP;
import static clinical.web.CBFBIRNConstants.PCASL_VARIANT;
import static clinical.web.CBFBIRNConstants.PICORE;
import static clinical.web.CBFBIRNConstants.VSASL;
import static clinical.web.CBFBIRNConstants.PCASL_EP2D_UCLA;
import static clinical.web.CBFBIRNConstants.D3PCASL;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.utils.DateTimeUtils;
import clinical.web.CBFBIRNConstants;
import clinical.web.vo.upload.SegmentInfo;
import clinical.web.vo.upload.VisitInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: CBFBirnHelper.java 806 2013-05-06 23:25:04Z bozyurt $
 */
public class CBFBirnHelper {

	public static JSONObject prepareExp2ViListMapAsJSON(
			Map<String, List<VisitInfo>> exp2ViListMap) throws JSONException {
		Map<String, Integer> expName2IdMap = new HashMap<String, Integer>(7);
		for (String expName : exp2ViListMap.keySet()) {
			List<VisitInfo> viList = exp2ViListMap.get(expName);
			int expId = viList.get(0).getExpId();
			expName2IdMap.put(expName, expId);
		}

		JSONObject js = new JSONObject();
		for (String expName : exp2ViListMap.keySet()) {
			List<VisitInfo> viList = exp2ViListMap.get(expName);
			Integer expId = expName2IdMap.get(expName);
			JSONObject expJS = new JSONObject();
			expJS.put("expName", expName);
			js.put(expId.toString(), expJS);
			JSONArray jsArr = new JSONArray();
			expJS.put("viList", jsArr);
			for (VisitInfo vi : viList) {
				JSONObject json = new JSONObject();
				json.put("visitId", vi.getVisitId());
				json.put("subjectId", vi.getSubjectID());
				json.put("date", DateTimeUtils.formatDate(vi.getVisitDate()));
				json.put("id", vi.getSubjectID() + "_" + vi.getVisitId());
				json.put("label", vi.getSubjectID() + " "
						+ DateTimeUtils.formatDate(vi.getVisitDate()) + " ("
						+ vi.getVisitId() + ")");
				if (vi.getScannerType() != null) {
					json.put("scanner", vi.getScannerType());
				} else {
					json.put("scanner", "");
				}
				json.put("hasAnat", vi.isHasAnat());
				json.put("hasFM", vi.isHasFieldMap());
				// IBO 7/13/2015
				json.put("has3DPCASL", vi.isHas3DPCASL());
				jsArr.put(json);
			}
		}

		return js;
	}

	public static Map<String, List<VisitInfo>> filterNonCBFProcessable(
			Map<String, List<VisitInfo>> exp2ViListMap) {
		ArrayList<String> keyList = new ArrayList<String>(exp2ViListMap
				.keySet());
		for (String key : keyList) {
			List<VisitInfo> viList = exp2ViListMap.get(key);
			for (Iterator<VisitInfo> it = viList.iterator(); it.hasNext();) {
				VisitInfo vi = it.next();
				boolean valid = false;
				for (SegmentInfo si : vi.getSiList()) {
					if (isCBFProcessable(si.getName())) {
						valid = true;
						break;
					}
				}
				if (!valid) {
					it.remove();
				}
			}
			if (viList.isEmpty()) {
				exp2ViListMap.remove(key);
			}
		}
		return exp2ViListMap;
	}

	public static Map<String, List<VisitInfo>> filterNonDTI(
			Map<String, List<VisitInfo>> exp2ViListMap) {
		ArrayList<String> keyList = new ArrayList<String>(exp2ViListMap
				.keySet());
		for (String key : keyList) {
			List<VisitInfo> viList = exp2ViListMap.get(key);
			for (Iterator<VisitInfo> it = viList.iterator(); it.hasNext();) {
				VisitInfo vi = it.next();
				boolean valid = false;
				for (SegmentInfo si : vi.getSiList()) {
					if (si.getName().equals(CBFBIRNConstants.DTI)) {
						valid = true;
						break;
					}
				}
				if (!valid) {
					it.remove();
				}
			}
			if (viList.isEmpty()) {
				exp2ViListMap.remove(key);
			}
		}
		return exp2ViListMap;
	}

	public static boolean isCBFProcessable(String seriesType) {
		if (seriesType.equals(PICORE) || seriesType.equals(PCASL)
				|| seriesType.equals(CASL) || seriesType.equals(VSASL)
				|| seriesType.equals(PCASL_4MP) || seriesType.equals(PCASL_8MP)
				|| seriesType.equals(PCASL_4MP_or_Opt_PCASL_Calib)
				|| seriesType.equals(PCASL_VARIANT)
				|| seriesType.equals(OPT_PCASL)
				|| seriesType.equals(OPT_PCASL_CALIB)
				|| seriesType.equals(EPISTAR) || seriesType.equals(FAIR)
				|| seriesType.equals(PCASL_EP2D_UCLA)
				// IBO 07/13/2015
				|| seriesType.equals(D3PCASL)

		) {
			return true;
		} else {
			for (String type : EMBEDDED_CSF_ASL_SERIES_ARR) {
				if (seriesType.equals(type)) {
					return true;
				}
			}
		}
		return false;
	}

	public static boolean isCBFProcessableAndEmbeddedCSF(String seriesType) {
		for (String type : EMBEDDED_CSF_ASL_SERIES_ARR) {
			if (seriesType.equals(type)) {
				return true;
			}
		}
		return false;
	}
	
	// IBO 07/14/2015
	public static boolean is3DPCASL(String seriesType) {
		return seriesType.equals(D3PCASL);
	}
 
}
