package clinical.web.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.apache.struts.util.LabelValueBean;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: CombinedScoreSelector.java,v 1.1 2007/04/12 17:09:44 bozyurt
 *          Exp $
 */
public class CombinedScoreSelector {
	Collection<LabelValueBean> scores;
	String selectedScore;

	public CombinedScoreSelector(Map<String, String> scoreKeyNameMap,
			List<String> regionNames) {
		scores = new ArrayList<LabelValueBean>(scoreKeyNameMap.size()
				+ regionNames.size());
		for (Map.Entry<String, String> entry : scoreKeyNameMap.entrySet()) {
			String scoreKey = entry.getKey();
			String scoreName = entry.getValue();
			LabelValueBean lvb = new LabelValueBean(scoreName, scoreKey);
			scores.add(lvb);
		}
		for (String regionName : regionNames) {
			LabelValueBean lvb = new LabelValueBean(regionName, regionName);
			scores.add(lvb);
		}
	}

	public Collection<LabelValueBean> getScores() {
		return scores;
	}

	public void setScores(Collection<LabelValueBean> scores) {
		this.scores = scores;
	}

	public String getSelectedScore() {
		return selectedScore;
	}

	public void setSelectedScore(String selectedScore) {
		this.selectedScore = selectedScore;
	}
}
