package clinical.web.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.apache.struts.util.LabelValueBean;

import clinical.web.common.security.DBConfig;

/**
 * @author I. Burak Ozyurt
 * @version $Id: DBConfigSelector.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class DBConfigSelector {
	protected Collection<LabelValueBean> dbConfigList;
	protected String selectedDBId;
	
	public DBConfigSelector(List<DBConfig> dbConfList) {
		dbConfigList = new ArrayList<LabelValueBean>(dbConfList.size());
		for(DBConfig dbConf : dbConfList) {
			dbConfigList.add( new LabelValueBean( dbConf.getId(), dbConf.getId()) );
			if ( dbConf.isDefaultDB()) {
				selectedDBId = dbConf.getId();
			}
		}
	}

	public Collection<LabelValueBean> getDbConfigList() {
		return dbConfigList;
	}

	public String getSelectedDBId() {
		return selectedDBId;
	}

	public void setSelectedDBId(String selectedDBId) {
		this.selectedDBId = selectedDBId;
	}
	
	public void addDBConfig(DBConfig dbConf) {
		dbConfigList.add( new LabelValueBean( dbConf.getId(), dbConf.getId()) );
	}

	public void removeDbConfig(String dbId) {
		LabelValueBean theLVB = null;

		for (LabelValueBean lvb  : dbConfigList) {
			if ( lvb.getLabel().equals(dbId)) {
				theLVB = lvb;
				break;
			}
		}
		if (theLVB != null) {
			dbConfigList.remove(theLVB);
		}	
	}
	
}
