package clinical.web.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.apache.struts.util.LabelValueBean;

import clinical.web.common.security.User;

/**
 * @author I. Burak Ozyurt
 * @version $Id: DbUserSelector.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class DbUserSelector {
	protected Collection<LabelValueBean> dbUserList;
	protected String selectedDBUserName;
	
	public DbUserSelector(List<User> userList) {
		dbUserList = new ArrayList<LabelValueBean>( userList.size());
		for (User user : userList) {
			dbUserList.add( new LabelValueBean(user.getName(), user.getName()));
		}
		selectedDBUserName = dbUserList.iterator().next().getValue();
	}

	public Collection<LabelValueBean> getDbUserList() {
		return dbUserList;
	}

	public String getSelectedDBUserName() {
		return selectedDBUserName;
	}

	public void setSelectedDBUserName(String selectedDBUserName) {
		this.selectedDBUserName = selectedDBUserName;
	}
	
	
}
