package clinical.web.helpers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: MultiValuedScoreGroupLayout.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class MultiValuedScoreGroupLayout implements java.io.Serializable {
	private static final long serialVersionUID = 1673407669037816775L;
	protected String assessmentName;
	protected List<MultiValuedScoreLayout> mvScoreLayouts = new ArrayList<MultiValuedScoreLayout>(2);

	public MultiValuedScoreGroupLayout() {
	}

	public MultiValuedScoreGroupLayout(String assessmentName) {
		this.assessmentName = assessmentName;
	}

	public void addMultiValuedScoreLayout(MultiValuedScoreLayout mvsl)
	{
		mvScoreLayouts.add(mvsl);
	}

	public List<MultiValuedScoreLayout> getMultiValuedScoreLayouts()
	{
		return mvScoreLayouts;
	}

	public void addMultiValuedScoreLayout(String scoreName, List<Object> values)
	{
		MultiValuedScoreLayout mvsl = new MultiValuedScoreLayout();
		mvsl.setScoreName(scoreName);
		mvsl.setValues(values);
		mvScoreLayouts.add(mvsl);
	}

	// ---------------------- setters --------------
	public void setAssessmentName(String newAssessmentName)
	{
		this.assessmentName = newAssessmentName;
	}

	// ---------------------- getters --------------
	public String getAssessmentName()
	{
		return this.assessmentName;
	}

	public int getColumnSize()
	{
		int maxCols = 0;
		for (Iterator<MultiValuedScoreLayout> iter = mvScoreLayouts.iterator(); iter.hasNext();) {
			MultiValuedScoreLayout mvsl = iter.next();
			if (maxCols < mvsl.getValues().size()) {
				maxCols = mvsl.getValues().size();
			}
		}
		return maxCols + 1;
	}
}
