package clinical.web.helpers;

import java.util.ArrayList;
import java.util.List;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: MultiValuedScoreLayout.java,v 1.1 2005/01/25 00:35:02 bozyurt
 *          Exp $
 */
public class MultiValuedScoreLayout {
	protected String scoreName;
	protected String assessmentName;
	protected List<Object> values = new ArrayList<Object>();

	public MultiValuedScoreLayout(String scoreName, String assessmentName) {
		this.scoreName = scoreName;
		this.assessmentName = assessmentName;
	}

	// ---------------------- setters --------------
	public void setScoreName(String newScoreName) {
		this.scoreName = newScoreName;
	}

	public void setAssessmentName(String newAssessmentName) {
		this.assessmentName = newAssessmentName;
	}

	// ---------------------- getters --------------
	public String getScoreName() {
		return this.scoreName;
	}

	public String getAssessmentName() {
		return this.assessmentName;
	}

	public MultiValuedScoreLayout() {
	}

	public void addValue(Object value) {
		values.add(value);
	}

	public void addValue(int idx, Object value) {
		values.set(idx, value);
	}

	public List<Object> getValues() {
		return values;
	}

	public void setValues(List<Object> valueList) {
		values = new ArrayList<Object>(valueList.size());
		for (Object value : valueList) {
			if (value == null) {
				values.add("");
			} else {
				values.add(value);
			}
		}
	}

	public int getColumnSize() {
		return values.size() + 1;
	}
}