package clinical.web.helpers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

import org.apache.struts.util.LabelValueBean;

import clinical.web.CBFBIRNConstants;

public class MultipleGAJobTypeSelector implements Serializable {
	private static final long serialVersionUID = 1L;
	public final static int ALL_JOBTYPES = -1;
	public final static int BASELINE = 1;
	public final static int NATIVE_ROI = 2;
	public final static int STANDARD_SPACE = 3;

	public final static String ALL_JOBTYPES_LABEL = "All Group Analysis Types";
	public final static String BASELINE_LABEL = "CBF Baseline Group Analyis";
	public final static String NATIVE_LABEL = "CBF ROI Group Analyis";
	public final static String SS_LABEL = "CBF Standard Space Analyis";
	private static int[] codes = { ALL_JOBTYPES, BASELINE, NATIVE_ROI,
			STANDARD_SPACE };
	private static String[] labels = { ALL_JOBTYPES_LABEL,
			CBFBIRNConstants.CBF_BASELINE_GROUP_ANALYSIS,
			CBFBIRNConstants.CBF_ROI_ANALYSIS,
			CBFBIRNConstants.CBF_STANDARD_SPACE_ANALYSIS };
	protected int[] selectedJobTypeIDs;
	protected Collection<LabelValueBean> jobTypeInfos;

	public MultipleGAJobTypeSelector() {
		jobTypeInfos = new ArrayList<LabelValueBean>(codes.length);
		for (int i = 0; i < codes.length; i++) {
			LabelValueBean lvb = new LabelValueBean(labels[i],
					String.valueOf(codes[i]));
			jobTypeInfos.add(lvb);
		}
		reset();
	}

	public void reset() {
		selectedJobTypeIDs = new int[1];
		selectedJobTypeIDs[0] = ALL_JOBTYPES;
	}

	public int[] getSelectedJobTypeIDs() {
		return selectedJobTypeIDs;
	}

	public void setSelectedJobTypeIDs(int[] selectedJobTypeIDs) {
		this.selectedJobTypeIDs = selectedJobTypeIDs;
	}

	public Collection<LabelValueBean> getJobTypeInfos() {
		return jobTypeInfos;
	}

}
