package clinical.web.helpers;

import java.util.LinkedList;
import java.util.List;

import clinical.web.Constants;

/**
 * Holds display layout information for an assessment instance for a particular
 * segment. Multi-valued score are grouped and represented differently than the
 * regular single valued scores.
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ScoreValuesDisplayLayout.java 710 2012-10-26 19:57:16Z bozyurt $
 */
public class ScoreValuesDisplayLayout {
	protected List<ScoreNameRowInfo> scoreNameRows = new LinkedList<ScoreNameRowInfo>();
	protected MultiValuedScoreGroupLayout mvScoreGroupLayout;
	/** number of columns for single answer assessment score values */
	protected int columnCount;

	public ScoreValuesDisplayLayout() {
		this.columnCount = Constants.MAX_COLUMNS_PER_ROW;
	}

	public ScoreValuesDisplayLayout(
			MultiValuedScoreGroupLayout mvScoreGroupLayout, int columnCount) {
		this.mvScoreGroupLayout = mvScoreGroupLayout;
		this.columnCount = columnCount;
	}

	public String toString() {
		StringBuilder buf = new StringBuilder(80);
		buf.append("ScoreValuesDisplayLayout::[");
		buf.append(", mvScoreGroupLayout=").append(mvScoreGroupLayout);
		buf.append(']');
		return buf.toString();
	}

	// ---------------------- setters --------------
	public void addScoreNameRowInfo(ScoreNameRowInfo scoreNameRowInfo) {
		scoreNameRows.add(scoreNameRowInfo);
	}

	public void setMvScoreGroupLayout(
			MultiValuedScoreGroupLayout newMvScoreGroupLayout) {
		this.mvScoreGroupLayout = newMvScoreGroupLayout;
	}

	public void setColumnCount(int newColumnCount) {
		this.columnCount = newColumnCount;
	}

	// ---------------------- getters --------------
	public List<ScoreNameRowInfo> getScoreNameRows() {
		return this.scoreNameRows;
	}

	public MultiValuedScoreGroupLayout getMvScoreGroupLayout() {
		return this.mvScoreGroupLayout;
	}

	public int getColumnCount() {
		return this.columnCount;
	}

}
