package clinical.web.helpers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

import org.apache.struts.util.LabelValueBean;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: StateSelector.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class StateSelector implements Serializable {
	private static final long serialVersionUID = 1L;
	protected Collection<LabelValueBean> states;
	protected String selectedState;
	
	private final static String[] stateArr = { "N/A", "Alabama", "Alaska", "Arizona",
		"Arkansas", "California", "Colorado", "Connecticut", "Delaware",
		"District of Columbia", "Florida", "Georgia", "Hawaii", "Idaho",
		"Illinois", "Indiana", "Iowa", "Kansas", "Kentucky", "Louisiana",
		"Maine", "Maryland", "Massachusetts", "Michigan", "Minnesota",
		"Mississippi", "Missouri", "Montana", "Nebraska", "Nevada",
		"New Hampshire", "New Jersey", "New Mexico", "New York",
		"North Carolina", "North Dakota", "Ohio", "Oklahoma", "Oregon",
		"Pennsylvania", "Rhode Island", "South Carolina", "South Dakota",
		"Tennessee", "Texas", "Utah", "Vermont", "Virginia", "Washington",
		"West Virginia", "Wisconsin", "Wyoming " };

	public StateSelector() {
		states = new ArrayList<LabelValueBean>(stateArr.length);
		for(String state : stateArr) {
			LabelValueBean lvb = new LabelValueBean(state, state);
			states.add(lvb);
		}
		this.selectedState = stateArr[0];
	}

	public String getSelectedState() {
		return selectedState;
	}

	public void setSelectedState(String selectedState) {
		this.selectedState = selectedState;
	}

	public Collection<LabelValueBean> getStates() {
		return states;
	}

}
