package clinical.web.helpers.security;

import java.sql.Connection;
import java.util.List;

import clinical.server.dao.ConfWebuserDAO;
import clinical.server.dao.ConfWebuserProjPrivDAO;
import clinical.server.vo.ConfWebuser;
import clinical.server.vo.ConfWebuserProjPriv;
import clinical.web.DAOFactory;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBPoolService;
import clinical.web.exception.DBPoolServiceException;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: AuthorizationHelper.java 366 2011-05-05 20:06:27Z bozyurt $
 */

public class AuthorizationHelper {
	private IDBPoolService pool = null;
	private String dbID;

	public AuthorizationHelper(String dbID) throws DBPoolServiceException {
		pool = ServiceFactory.getPoolService(dbID);
		this.dbID = dbID;
	}

	public UserPrivilegeSet prepareUserPrivileges(String user, String adminUser)
			throws Exception {
		UserPrivilegeSet ups = new UserPrivilegeSet(user);
		Connection con = null;
		try {
			con = pool.getConnection(adminUser);
			ConfWebuserProjPrivDAO ppDAO = DAOFactory
					.createConfWebuserProjPrivDAO(dbID);
			ConfWebuserDAO wuDAO = DAOFactory.createConfWebuserDAO(dbID);
			ConfWebuser cucr = new ConfWebuser();
			cucr.setName(user);
			List<ConfWebuser> cuList = wuDAO.find(con, cucr);
			if (cuList.isEmpty()) {
				throw new Exception("Not a valid web user:" + user);
			}
			ConfWebuser wu = cuList.get(0);

			ConfWebuserProjPriv cr = new ConfWebuserProjPriv();
			cr.setWebuserId(wu.getUniqueId());
			List<ConfWebuserProjPriv> wuppList = ppDAO.find(con, cr);
			for (ConfWebuserProjPriv wupp : wuppList) {
				ups.addPrivilege(wupp.getExpId().intValue(), wupp.getPrivName());
			}
		} finally {
			pool.releaseConnection(adminUser, con);
		}
		return ups;
	}

}