package clinical.web.helpers.security;

import java.util.HashSet;
import java.util.Set;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: UserPrivilegeSet.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class UserPrivilegeSet {
	private String userName;
	private Set<PrivilegeKey> privSet = new HashSet<PrivilegeKey>(17);

	public UserPrivilegeSet(String userName) {
		super();
		this.userName = userName;
	}

	void addPrivilege(int expId, String privilege) {
		PrivilegeKey key = new PrivilegeKey(expId, privilege);
		privSet.add(key);
	}

	public boolean hasPrivilege(int expId, String privilege) {
		PrivilegeKey key = new PrivilegeKey(expId, privilege);
		return privSet.contains(key);
	}

	public boolean hasPrivilege(String privilege) {
		for (PrivilegeKey pk : privSet) {
			if (pk.privilege.equals(privilege))
				return true;
		}
		return false;
	}

	public static class PrivilegeKey {
		private int expId;
		private String privilege;

		public PrivilegeKey(int expId, String privilege) {
			this.expId = expId;
			this.privilege = privilege;
		}

		public int getExpId() {
			return expId;
		}

		public String getPrivilege() {
			return privilege;
		}

		public int hashCode() {
			final int prime = 31;
			int result = 1;
			result = prime * result + expId;
			result = prime * result
					+ ((privilege == null) ? 0 : privilege.hashCode());
			return result;
		}

		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			PrivilegeKey other = (PrivilegeKey) obj;
			if (expId != other.expId)
				return false;
			if (privilege == null) {
				if (other.privilege != null)
					return false;
			} else if (!privilege.equals(other.privilege))
				return false;
			return true;
		}
	}// ;

	public String getUserName() {
		return userName;
	}

}
