package clinical.web.image.viewer.plugins;

import imagelib.io.dicom.DICOMDataElement;
import imagelib.io.dicom.DICOMDecoder;
import imagelib.util.Utils;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

import org.dcm4che2.imageio.plugins.dcm.DicomImageReadParam;

import clinical.web.image.viewer.IPlugin;
import clinical.web.image.viewer.PluginException;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: DICOMPlugin.java 699 2012-10-18 00:12:42Z bozyurt $
 */
public class DICOMPlugin implements IPlugin {

	@Override
	public void convertToJpeg(File srcDir, File destDir) throws PluginException {
		File[] files = getDirContents(srcDir);
		List<File> dicomFiles = new ArrayList<File>();
		Map<String, DICOMDataElement> ddeMap = new HashMap<String, DICOMDataElement>();
		try {
			for (File file : files) {
				if (!file.isFile())
					continue;
				String path = file.getAbsolutePath();
				if (!DICOMDecoder.isDICOMFile(path))
					continue;
				dicomFiles.add(file);

				DICOMDecoder dd = new DICOMDecoder(path);
				ddeMap.clear();
				dd.getImageDataStartPos(path, ddeMap);
				DICOMDataElement dde = ddeMap.get("InstanceNumber");
				if (dde != null) {
					File jpegFile = new File(destDir, dde.getValue().trim()
							+ ".jpeg");
					convert(file, jpegFile);
				}
			}
		} catch (Throwable t) {
			throw new PluginException(t);
		}
	}

	@Override
	public String[] getSupportedImageTypes() {
		return new String[] { "DICOM" };
	}

	@Override
	public boolean isSupported(String imageType) {
		return imageType.equalsIgnoreCase("dicom");
	}

	protected void convert(File dcmFile, File jpegFile) throws IOException {
		BufferedImage jpegImage = null;
		Iterator<ImageReader> iter = ImageIO
				.getImageReadersByFormatName("DICOM");
		if (!iter.hasNext()) {
			ImageIO.scanForPlugins();
			iter = ImageIO.getImageReadersByFormatName("DICOM");
		}
		ImageReader ir = iter.next();
		DicomImageReadParam param = (DicomImageReadParam) ir
				.getDefaultReadParam();
		ImageInputStream in = null;
		OutputStream out = null;
		try {
			in = ImageIO.createImageInputStream(dcmFile);
			ir.setInput(in, false);
			jpegImage = ir.read(0, param);
			out = new BufferedOutputStream(new FileOutputStream(jpegFile), 4096);

			ImageIO.write(jpegImage, "jpeg", out);

			// JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder(out);
			// encoder.encode(jpegImage);
		} finally {
			if (in != null) {
				try {
					in.close();
				} catch (Exception x) {
				}
			}
			Utils.close(out);
		}
	}

	public static File[] getDirContents(File dir) {
		if (!dir.isDirectory())
			return null;
		return dir.listFiles();
	}

}
