package clinical.web.scheduler;

/**
 * holds information for jobs tied to a specific visit of an subject and needs
 * to associated with a JobRecord. A JobRecord can have zero or more of these
 * objects.
 * 
 * @author I. Burak Ozyurt
 * @version $Id: JobVisitContext.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class JobVisitContext {
	int expID;
	int visitID;
	String subjectID;

	public JobVisitContext(int expID, int visitID, String subjectID) {
		super();
		this.expID = expID;
		this.visitID = visitID;
		this.subjectID = subjectID;
	}

	public int getExpID() {
		return expID;
	}

	public int getVisitID() {
		return visitID;
	}

	public String getSubjectID() {
		return subjectID;
	}
}
