package clinical.web.services;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import clinical.event.SequenceCreateEvent;
import clinical.event.SequenceCreateEventListener;
import clinical.web.ISequenceHelper;
import clinical.web.MinimalServiceFactory;
import clinical.web.common.IDBPoolService;
import clinical.web.common.ISecurityService;
import clinical.web.common.UserInfo;
import clinical.web.exception.BaseException;
import clinical.web.exception.DBPoolServiceException;

/**
 * abstract class for database sequence retrieval.
 * 
 * @author I. Burak Ozyurt
 * @version $Id: AbstractSequenceHelper.java,v 1.2 2004/08/17 00:49:58 bozyurt
 *          Exp $
 */
public abstract class AbstractSequenceHelper implements ISequenceHelper {
	protected IDBPoolService dbPoolService;
	protected String dbType;
	protected Log log = LogFactory.getLog(AbstractSequenceHelper.class);
	protected static Map<String, ISequenceHelper> instanceMap = new HashMap<String, ISequenceHelper>(
			7);
	public List<SequenceCreateEventListener> listeners = new ArrayList<SequenceCreateEventListener>(
			1);

	protected AbstractSequenceHelper(String dbID) throws BaseException {
		dbPoolService = MinimalServiceFactory.getPoolService(dbID);
		ISecurityService isec = MinimalServiceFactory.getSecurityService();
		dbType = isec.getDBType(dbID);
	}

	public abstract BigDecimal getNextUID(Connection con, String tableName,
			String columnName) throws BaseException;

	public abstract BigDecimal getNextUID(UserInfo ui, String tableName,
			String columnName) throws BaseException;

	protected void releaseConnection(Connection con, UserInfo ui) {
		if (con == null)
			return;
		try {
			dbPoolService.releaseConnection(ui.getName(), con);
		} catch (DBPoolServiceException x) {
			log.error("Cannot release connection for user " + ui.getName(), x);
		}
	}

	public void addListener(SequenceCreateEventListener lsnr) {
		listeners.add(lsnr);
	}

	public void removeListener(SequenceCreateEventListener lsnr) {
		listeners.remove(lsnr);
	}

	protected void fireSequenceNumCreateEvent(String tableName,
			String columnName, String sequenceNum) {
		if (listeners.isEmpty())
			return;
		if (listeners.size() == 1) {
			SequenceCreateEventListener lsnr = listeners.get(0);
			lsnr.sequenceNoCreated(new SequenceCreateEvent(tableName,
					columnName, sequenceNum));
		} else {
            List<SequenceCreateEventListener> copy = new ArrayList<SequenceCreateEventListener>( listeners );
            for (SequenceCreateEventListener lsnr : copy) {
            	lsnr.sequenceNoCreated(new SequenceCreateEvent(tableName,
    					columnName, sequenceNum));
			}
		}
	}

}