package clinical.web.services;

import java.io.File;
import java.sql.Connection;
import java.util.List;

import clinical.web.common.UserInfo;
import clinical.web.common.vo.CBFProcessReportRec;
import clinical.web.services.BatchAssessmentServiceImpl.CSVTable;
import clinical.web.vo.GroupAnalysisCBFJobInfo;

public interface ICBFStandardSpaceGroupAnalysisService {

	public void prepareProcessInputData(UserInfo ui, File inputRootDir,
			List<GroupAnalysisCBFJobInfo> gajiList) throws Exception;

	public CSVTable loadAssessmentData(UserInfo ui,
			List<GroupAnalysisCBFJobInfo> gajiList) throws Exception;

	public List<GroupAnalysisCBFJobInfo> toGroupAnalysisJobInfoList(
			UserInfo ui, List<CBFProcessReportRec> cbfRecList) throws Exception;

	public List<GroupAnalysisCBFJobInfo> toGroupAnalysisJobInfoList(
			Connection con, List<CBFProcessReportRec> cbfRecList)
			throws Exception;

}