package clinical.web.services;

import clinical.web.IAppConfigService;

/**
 * periodically updates {@link IAppConfigService} parameters from the database
 * to pickup any changes on the configuration parameters after system startup.
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class PeriodicConfigUpdateService implements IPeriodicService {
	private IAppConfigService confService;
	private final static long checkInterval = 1800000l; // every half hour

	public PeriodicConfigUpdateService(IAppConfigService confService) {
		this.confService = confService;
	}

	@Override
	public long getPeriod() {
		return checkInterval;
	}

	@Override
	public void service() throws Exception {
		confService.reload();
	}
}
