package clinical.web.services;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class PeriodicServiceManagementService implements Runnable {
	private List<ServiceTime> services = new ArrayList<ServiceTime>();
	private long checkInterval;
	private boolean canceled = false;
	private static Log log = LogFactory
			.getLog(PeriodicServiceManagementService.class);

	public PeriodicServiceManagementService() {
		this(120000l); // every 2 minutes
	}

	public PeriodicServiceManagementService(long checkInterval) {
		if (checkInterval > 0) {
			this.checkInterval = checkInterval;
		}
	}

	/**
	 * intentionally not thread safe. All the services must be registered BEFORE
	 * starting this service on the background.
	 * 
	 * @param service
	 */
	public void register(IPeriodicService service) {
		services.add(new ServiceTime(service));
	}
	
	public int getNumRegisteredServices() {
		return services.size();
	}

	@Override
	public void run() {
		boolean first = true;
		while (true) {
			if (isCanceled()) {
				break;
			}
			for (ServiceTime st : services) {
				long now = System.currentTimeMillis();
				try {
					if (first || isDue(st, now)) {
						st.getService().service();
						st.setLastRun(System.currentTimeMillis());
					}
				} catch (Exception e) {
					log.error("Periodic service error:", e);
				}
			}
			synchronized (this) {
				try {
					wait(checkInterval);
				} catch (InterruptedException iex) {
				}
			}
			first = false;
		}
	}

	private boolean isDue(ServiceTime st, long now) {
		long diff = now - st.getLastRun();
		return (diff >= st.getService().getPeriod());
	}

	public synchronized boolean isCanceled() {
		return canceled;
	}

	/**
	 * make sure to notify this thread after this call
	 * 
	 * @param canceled
	 */
	public synchronized void setCanceled(boolean canceled) {
		this.canceled = canceled;
	}

	private class ServiceTime {
		IPeriodicService service;
		long lastRun = 0;

		public ServiceTime(IPeriodicService service) {
			this.service = service;
		}

		long getLastRun() {
			return lastRun;
		}

		void setLastRun(long lastRun) {
			this.lastRun = lastRun;
		}

		IPeriodicService getService() {
			return service;
		}

	}

}
