package clinical.web.services;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import clinical.web.DBUtils;
import clinical.web.common.UserInfo;
import clinical.web.exception.BaseException;

/**
 * Encapsulates Postgres database sequence retrieval.
 * 
 * @author I. Burak Ozyurt
 * @version $Id: PostgresSequenceHelper.java,v 1.2 2004/08/17 00:49:58 bozyurt
 *          Exp $
 */
public class PostgresSequenceHelper extends AbstractSequenceHelper {

	protected PostgresSequenceHelper(String dbID) throws BaseException {
		super(dbID);
	}

	public synchronized static PostgresSequenceHelper getInstance(String dbID,
			String dbType) throws BaseException {
		PostgresSequenceHelper seqHelper = (PostgresSequenceHelper) instanceMap
				.get(dbID + '_' + dbType);
		if (seqHelper == null) {
			seqHelper = new PostgresSequenceHelper(dbID);
			instanceMap.put(dbID, seqHelper);
		}
		return seqHelper;
	}

	public BigDecimal getNextUID(Connection con, String tableName,
			String columnName) throws BaseException {
		Statement st = null;
		ResultSet rs = null;
		try {
			st = con.createStatement();
			rs = st.executeQuery("select nextval('uid_seq')");
			if (rs.next()) {
				BigDecimal uid = rs.getBigDecimal(1);
				fireSequenceNumCreateEvent(tableName, columnName, uid.toString());
				return uid;
			}
		} catch (SQLException x) {
			throw new BaseException(x);
		} finally {
			DBUtils.close(st, rs);		
		}
		return null;
	}

	public BigDecimal getNextUID(UserInfo ui, String tableName,
			String columnName) throws BaseException {
		Connection con = null;
		Statement st = null;
		try {
			con = dbPoolService.getConnection(ui.getName());
			st = con.createStatement();
			ResultSet rs = st.executeQuery("select nextval('uid_seq')");
			if (rs.next()) {
				BigDecimal uid = rs.getBigDecimal(1);
				fireSequenceNumCreateEvent(tableName, columnName, uid.toString());
				return uid;
			}
		} catch (Exception x) {
			log.error("", x);
			throw new BaseException(x);
		} finally {
			DBUtils.close(st);
			releaseConnection(con, ui);
		}
		return null;
	}

}