package clinical.web.upload;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import clinical.server.dao.RawdataDAO;
import clinical.server.vo.Collectionequipment;
import clinical.server.vo.Databaseuser;
import clinical.server.vo.Experiment;
import clinical.server.vo.Humansubject;
import clinical.server.vo.Rawdata;
import clinical.server.vo.Researchgroup;
import clinical.server.vo.Subjexperiment;
import clinical.utils.Assertion;
import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.web.DAOFactory;
import clinical.web.DBUtils;
import clinical.web.IExperimentManagement;
import clinical.web.ISequenceHelper;
import clinical.web.ISubjectVisitManagement;
import clinical.web.MinimalServiceFactory;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBCache;
import clinical.web.common.IDBPoolService;
import clinical.web.common.UserInfo;
import clinical.web.exception.BaseException;
import clinical.web.vo.Subject;
import clinical.web.vo.Visit;
import clinical.web.vo.VisitSegment;

/**
 * TODO not used - remove
 * 
 * @author I. Burak Ozyurt
 * @version $Id: UploadHandler.java 197 2010-03-05 00:11:21Z bozyurt $
 */
public class UploadHandler {
	private UploadContext ctx;
	private UserInfo ui;
	private static Log log = LogFactory.getLog("UploadHandler");

	public UploadHandler(UploadContext ctx, UserInfo ui) {
		this.ctx = ctx;
		this.ui = ui;
	}

	public void uploadVisit(UploadVisit uv) throws Exception {
		IDBCache dbCache = null;
		Connection con = null;
		IDBPoolService dbPoolService = null;
		try {
			dbPoolService = ServiceFactory.getPoolService(ctx.getDbID());
			con = dbPoolService.getConnection(ui.getName());
			con.setAutoCommit(false);
			dbCache = ServiceFactory.getDBCache(ctx.getDbID());
			List<Experiment> expList = dbCache.getExperiments(ui, false);
			Experiment theExp = findExperiment(uv.getExpName(), expList);
			Assertion.assertNotNull(theExp);
			int expID = theExp.getUniqueid().intValue();
			uv.getVisit().setExperimentID(expID);
			for (VisitSegment vs : uv.getVisit().getVisitSegments()) {
				vs.setExperimentID(expID);
			}
			IExperimentManagement em = ServiceFactory.getExperimentManagement(ctx
					.getDbID());
			List<Subjexperiment> subjExpList = em.getEnrolledSubjects(ui, theExp
					.getUniqueid().intValue());
			Subjexperiment theSE = findSubjExperiment(
					uv.getVisit().getSubjectID(), subjExpList);
			if (theSE == null) {
				theSE = enrollSubject(con, uv, em);
				addVisitForSubject(con, ui, uv);
			} else {
				ISubjectVisitManagement isvm = ServiceFactory
						.getSubjectVisitManagement(ctx.getDbID());
				List<Visit> visitList = isvm.getAllVisitsForSubject(ui, uv
						.getVisit().getSubjectID());
				if (visitList.isEmpty()) {
					addVisitForSubject(con, ui, uv);
				} else {
					Visit theVisit = findVisit(uv.getVisit(), visitList);
					if (theVisit == null) {
						addVisitForSubject(con, ui, uv);
					} else {
						throw new Exception(
								"A visit with same time stamp already exists for subject "
										+ uv.getVisit().getSubjectID());
					}
				}
			}
			List<Collectionequipment> equipments = dbCache
					.getCollectionEquipments(ui, true);
         // add uris to data for this visit
			addPointers(con, uv, equipments);
         
			con.commit();
		} catch (Throwable t) {
			try {
				con.rollback();
			} catch (Exception e) {
				log.error("rollback error", e);
			}
			throw new Exception(t.getMessage());
		} finally {
			if (dbPoolService != null) {
				dbPoolService.releaseConnection(ui.getName(), con);
			}
		}
	}

	protected void addPointers(Connection con, UploadVisit uv,
			List<Collectionequipment> equipments) throws Exception {
        Map<String, Collectionequipment> eqMap = new HashMap<String, Collectionequipment>(7);
        for(Collectionequipment eq : equipments) {
      	  String key = eq.getMake() + ":" + eq.getModel();
      	  eqMap.put(key, eq);
        }
        for(VisitSegment vs : uv.getVisit().getVisitSegments()) {
      	  String key = vs.getEquipment().getMake() + ":" + vs.getEquipment().getModel();
      	  Collectionequipment eq = eqMap.get(key);
      	  Assertion.assertNotNull(eq);
      	  List<String> pointers = uv.getPointers(vs);
      	  for(String dataURI : pointers) {
      		  addRawData(con, vs, dataURI, eq);
      	  }      	  
        }
	}

	protected void addVisitForSubject(Connection con, UserInfo ui, UploadVisit uv)
			throws BaseException {
		ISubjectVisitManagement isvm = ServiceFactory
				.getSubjectVisitManagement(ctx.getDbID());

		isvm.addVisitForSubjectNonContiguous(con, ui, uv.getVisit());
	}

	protected Subjexperiment enrollSubject(Connection con, UploadVisit uv,
			IExperimentManagement em) throws Exception {
		ISubjectVisitManagement isvm = ServiceFactory
				.getSubjectVisitManagement(ctx.getDbID());
		IDBCache dbCache = ServiceFactory.getDBCache(ctx.getDbID());
		Humansubject hs = isvm.getSubjectByID(ui, uv.getVisit().getSubjectID());
		if (hs == null) {
			Subject subject = new Subject(uv.getVisit().getSubjectID());
			isvm.addSubject(ui, subject);
		}
		List<Researchgroup> rgList = dbCache.getResearchGroups(ui, false);
		Researchgroup theRG = null;
		Visit v = uv.getVisit();
		for (Researchgroup rg : rgList) {
			if (rg.getName().equals(uv.getSubjectGroupID())
					&& rg.getNcExperimentUniqueid().equals(v.getExperimentID())) {
				theRG = rg;
				break;
			}
		}
		if (theRG == null) {
			throw new Exception("Unknown subject group ID:"
					+ uv.getSubjectGroupID());
		}
		Subjexperiment se = em.enrollSubject(ui, v.getExperimentID(), v
				.getSubjectID(), theRG.getUniqueid().intValue());
		return se;
	}

	protected void addRawData(Connection con, VisitSegment vs, String dataURI, Collectionequipment eq)
			throws Exception {
		Databaseuser dbUser = DBUtils.getDatabaseUser(ui,
				Constants.USERCLASS_ADMIN, ctx.getDbID());
		Assertion.assertNotNull(dbUser);

		RawdataDAO dao = DAOFactory.createRawdataDAO(ctx.getDbID());
		Rawdata rd = new Rawdata();
		ISequenceHelper sequenceHelper = MinimalServiceFactory
				.getSequenceHelper(ctx.getDbID());
		rd.setComponentid(GenUtils.toBigDecimal(vs.getVisitID()));
		rd.setNcExperimentUniqueid(GenUtils.toBigDecimal(vs.getExperimentID()));
		rd.setSubjectid(vs.getSubjectID());
		rd.setSegmentid(GenUtils.toBigDecimal(vs.getSegmentID()));
		rd.setDatauri(dataURI);
		rd.setProtocolid(vs.getProtocolID());
		rd.setProtocolversion(GenUtils.toBigDecimal(vs.getProtocolVersion()));
		rd.setNcColequipmentUniqueid(eq.getUniqueid());

		rd.setOwner(dbUser.getUniqueid());
		rd.setModuser(dbUser.getUniqueid());
		rd.setModtime(new Date());
		rd.setOntologysource(Constants.DEFAULT_ONT_SRC);
		rd.setConceptid(Constants.DEFAULT_ONT_CONCEPT);
		BigDecimal uniqueid = sequenceHelper.getNextUID(con, Constants.RAWDATA,
				"uniqueid");
		rd.setExtensionname("nc_rawdata");
		rd.setIsraw(true);
		rd.setUniqueid(uniqueid);
		rd.setTableid(DBUtils.getTableID(ui, Constants.RAWDATA, ctx.getDbID()));

		dao.insert(con, rd);
	}

	public static Visit findVisit(Visit criterion, List<Visit> visitList) {
		for (Visit v : visitList) {
			if (v.getTs().equals(criterion.getTs())) {
				return v;
			}
		}
		return null;
	}

	public static Subjexperiment findSubjExperiment(String subjectID,
			List<Subjexperiment> subjExpList) {
		for (Subjexperiment se : subjExpList) {
			if (se.getSubjectid().equals(subjectID)) {
				return se;
			}
		}
		return null;
	}

	public static Experiment findExperiment(String projectID,
			List<Experiment> expList) {
		for (Experiment exp : expList) {
			if (exp.getName().equals(projectID)) {
				return exp;
			}
		}
		return null;
	}

}
