package clinical.web.vo;

import java.util.ArrayList;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.server.vo.Experiment;
import clinical.web.common.vo.AssessmentSelectionInfo;

/**
 * returned to the search component as metadata 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class CBFQueryMetaData {
	private List<AssessmentSelectionInfo> asiList;
	private JobProvenanceMetadata provMetadata;
	private List<JobResultGroupInfo> jrgiList;
	private List<MinExpInfo> expList;

	public CBFQueryMetaData(List<AssessmentSelectionInfo> asiList,
			JobProvenanceMetadata provMetadata,
			List<JobResultGroupInfo> jrgiList, List<Experiment> experiments) {
		super();
		this.asiList = asiList;
		this.provMetadata = provMetadata;
		this.jrgiList = jrgiList;
		expList = new ArrayList<MinExpInfo>(experiments.size());
		for (Experiment exp : experiments) {
			expList.add(new MinExpInfo(exp.getUniqueid().intValue(), exp
					.getName()));
		}
	}

	public static class MinExpInfo {
		private Integer expId;
		private String expName;

		public MinExpInfo(Integer expId, String expName) {
			super();
			this.expId = expId;
			this.expName = expName;
		}

		public JSONObject toJSON() throws JSONException {
			JSONObject js = new JSONObject();
			js.put("id", expId.intValue());
			js.put("name", expName);
			return js;
		}
	}// ;

	public List<AssessmentSelectionInfo> getAsiList() {
		return asiList;
	}

	public JobProvenanceMetadata getProvMetadata() {
		return provMetadata;
	}

	public List<JobResultGroupInfo> getJrgiList() {
		return jrgiList;
	}

	public List<MinExpInfo> getExpList() {
		return expList;
	}

	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		JSONArray asiJSArr = new JSONArray();
		js.put("asiList", asiJSArr);
		if (asiList != null) {
			for (AssessmentSelectionInfo asi : asiList) {
				asiJSArr.put(asi.toJSON(new JSONObject()));
			}
		}

		if (provMetadata != null) {
			js.put("provMetaData", provMetadata.toJSON());
		}
		if (jrgiList != null) {
			JSONArray jsArr = new JSONArray();
			js.put("derivedMetaData", jsArr);
			for (JobResultGroupInfo jrgi : jrgiList) {
				jsArr.put(jrgi.toJSON(new JSONObject()));
			}
		}
		
		if (expList != null) {
			JSONArray jsArr = new JSONArray();
			js.put("expList", jsArr);
			for(MinExpInfo mei : expList) {
				jsArr.put( mei.toJSON());
			}
		}

		return js;
	}
}
