package clinical.web.vo;

import clinical.server.vo.Person;

public class ContactPerson {
   protected String firstName;
   protected String lastName;
   protected String email;
   protected int uniqueID;

   public ContactPerson() {
   }

   public ContactPerson(Person person) {
      firstName = person.getFirstName();
      lastName = person.getLastName();
      email = person.getEmail();
      uniqueID = person.getUniqueid().intValue();
   }

   // ---------------------- setters --------------
   public void setFirstName(String newFirstName) {
      this.firstName = newFirstName;
   }
   public void setLastName(String newLastName) {
      this.lastName = newLastName;
   }
   public void setEmail(String newEmail) {
      this.email = newEmail;
   }
   public void setUniqueID(int newUniqueID) {
      this.uniqueID = newUniqueID;
   }

   // ---------------------- getters --------------
   public String getFirstName() {
      return this.firstName;
   }
   public String getLastName() {
      return this.lastName;
   }
   public String getEmail() {
      return this.email;
   }
   public int getUniqueID() {
      return this.uniqueID;
   }

   public String getFullName() {
      String fname = firstName.toLowerCase();
      String lname = lastName.toLowerCase();
      StringBuffer buf = new StringBuffer();
      buf.append(fname);
      buf.setCharAt(0, Character.toUpperCase(buf.charAt(0)));
      buf.append(' ');
      int idx = buf.length();
      buf.append(lname);
      if (lname.length() > 0) {
         buf.setCharAt(idx, Character.toUpperCase(buf.charAt(idx)));
      }
      return buf.toString().trim();
   }
}
