package clinical.web.vo;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author I. Burak Ozyurt
 * @version $Id: ExecutedTransformInfo.java,v 1.1 2008/02/06 01:44:31 bozyurt
 *          Exp $
 */
public class ExecutedTransformInfo {
	protected AnalysisInfo analysis;
	protected TransformationInfo transform;
	protected int nodeLevel = 1;
	protected AnalysisCompInfo component;
	protected MachineInfo machine;
	protected ExecutedTransformInfo parent;
	protected String argUsed;
	protected Date timestamp;
	protected List<DerivedDataInfo> inputDDIList = new ArrayList<DerivedDataInfo>(1);
	protected List<DerivedDataInfo> outputDDIList = new ArrayList<DerivedDataInfo>(5);
	

	public ExecutedTransformInfo() {
	}

	public AnalysisInfo getAnalysis() {
		return analysis;
	}

	public TransformationInfo getTransform() {
		return transform;
	}

	public int getNodeLevel() {
		return nodeLevel;
	}

	public AnalysisCompInfo getComponent() {
		return component;
	}

	public MachineInfo getMachine() {
		return machine;
	}

	public ExecutedTransformInfo getParent() {
		return parent;
	}

	public void setAnalysis(AnalysisInfo analysis) {
		this.analysis = analysis;
	}

	public void setTransform(TransformationInfo transform) {
		this.transform = transform;
	}

	public void setNodeLevel(int nodeLevel) {
		this.nodeLevel = nodeLevel;
	}

	public void setComponent(AnalysisCompInfo component) {
		this.component = component;
	}

	public void setMachine(MachineInfo machine) {
		this.machine = machine;
	}

	public void setParent(ExecutedTransformInfo parent) {
		this.parent = parent;
	}

	public String getArgUsed() {
		return argUsed;
	}

	public void setArgUsed(String argUsed) {
		this.argUsed = argUsed;
	}

	public Date getTimestamp() {
		return timestamp;
	}

	public void setTimestamp(Date timestamp) {
		this.timestamp = timestamp;
	}

	public void addInputDerivedDataInfo(DerivedDataInfo ddi) {
		inputDDIList.add(ddi);
	}

	public List<DerivedDataInfo> getInputDDIList() {
		return inputDDIList;
	}

	public void addOutputDerivedDataInfo(DerivedDataInfo ddi) {
		outputDDIList.add(ddi);
	}
	
	public List<DerivedDataInfo> getOutputDDIList() {
		return outputDDIList;
	}
}
