package clinical.web.vo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import clinical.server.vo.ContactInfo;
import clinical.server.vo.Experiment;
import clinical.server.vo.UsageData;

/**
 * holds experiment, contact, funding information combined for a project
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class ProjectInfo implements Serializable {
	private static final long serialVersionUID = 1L;
	private Experiment experiment;
	private ContactInfo contactInfo;
	private List<UsageData> usageDataList = new ArrayList<UsageData>(1);

	public ProjectInfo(Experiment exp, ContactInfo ci,
			List<UsageData> usageDataList) {
		this.experiment = exp;
		this.contactInfo = ci;
		this.usageDataList = usageDataList;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public Experiment getExperiment() {
		return experiment;
	}

	public ContactInfo getContactInfo() {
		return contactInfo;
	}

	public List<UsageData> getUsageDataList() {
		return usageDataList;
	}

	public String getPiName() {
		if (contactInfo == null) {
			return "";
		}
		StringBuilder sb = new StringBuilder();
		if ( contactInfo.getFirstName() != null) {
			sb.append(contactInfo.getFirstName()).append(' ');
		}
		if (contactInfo.getLastName() != null) {
			sb.append(contactInfo.getLastName());
		}
		
		return sb.toString().trim();
	}
	
	
	public String getInstitution() {
		if (contactInfo == null) {
			return "";
		}
		return contactInfo.getInstitution();
	}
	
	public String getExpIdStr() {
		return experiment.getUniqueid().toString();
	}
}
