package clinical.web.vo;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class ProvenanceResultSummary implements Serializable {
	private static final long serialVersionUID = 1L;
	private String subjectID;
	private String expID;
	private String expName = "unknown";
	private Map<String, VisitProvResultValues> vprvMap = new LinkedHashMap<String, VisitProvResultValues>(
			3);

	public ProvenanceResultSummary(String subjectID, String expID,
			String expName) {
		super();
		this.subjectID = subjectID;
		this.expID = expID;
		this.expName = expName;
	}
	
	public String toString() {
		StringBuilder sb = new StringBuilder(512);
		sb.append("ProvenanceResultSummary::[");
		sb.append("subjectID:").append(subjectID);
		sb.append(",expID:").append(expID);
		sb.append(",expName:").append(expName);
		for(VisitProvResultValues vprv : vprvMap.values()) {
			sb.append("\n\t").append(vprv);
		}
		sb.append(']');
		return sb.toString();
		
	};

	public String getExpName() {
		return expName;
	}

	public String getSubjectID() {
		return subjectID;
	}

	public String getExpID() {
		return expID;
	}

	public Map<String, VisitProvResultValues> getVprvMap() {
		return vprvMap;
	}

	public String getKey() {
		StringBuilder sb = new StringBuilder();
		sb.append(subjectID).append(':').append(expID);
		return sb.toString();
	}

	public VisitProvResultValues getOrAdd(int visitID, int experimentID,
			int jobUniqueID) {
		if (!this.expID.equals(String.valueOf(experimentID))) {
			throw new RuntimeException("Invalid expID:" + experimentID
					+ " Expected:" + this.expID);
		}
		String key = prepVisitProvResultValuesKey(visitID, experimentID,
				jobUniqueID);
		VisitProvResultValues vprv = vprvMap.get(key);
		if (vprv == null) {
			vprv = new VisitProvResultValues(visitID, experimentID, jobUniqueID);
			vprvMap.put(key, vprv);
		}
		return vprv;
	}

	public VisitProvResultValues get(int visitID, int experimentID,
			int jobUniqueID) {
		String key = prepVisitProvResultValuesKey(visitID, experimentID,
				jobUniqueID);
		return vprvMap.get(key);
	}

	public static String prepVisitProvResultValuesKey(int visitID, int expID,
			int jobUniqueID) {
		StringBuilder sb = new StringBuilder();
		sb.append(expID).append(':').append(visitID).append(':')
				.append(jobUniqueID);
		return sb.toString();
	}

	public static class VisitProvResultValues implements Serializable {
		private static final long serialVersionUID = 1L;
		private int visitID;
		private int expID;
		private int jobUniqueID;
		private Map<String, JobProvenanceValueSummary> jpvsMap = new LinkedHashMap<String, JobProvenanceValueSummary>(
				3);

		public VisitProvResultValues(int visitID, int expID, int jobUniqueID) {
			super();
			this.visitID = visitID;
			this.expID = expID;
			this.jobUniqueID = jobUniqueID;
		}

		public void add(JobProvenanceValueSummary jpvs) {
			jpvsMap.put(jpvs.getName(), jpvs);
		}

		public int getVisitID() {
			return visitID;
		}

		public int getExpID() {
			return expID;
		}

		public Map<String, JobProvenanceValueSummary> getJpvsMap() {
			return jpvsMap;
		}

		public int getJobUniqueID() {
			return jobUniqueID;
		}

		@Override
		public String toString() {
			StringBuilder sb = new StringBuilder(256);
			sb.append("VisitProvResultValues::[");
			sb.append("expID=").append(expID);
			sb.append(",visitID=").append(visitID);
			sb.append(",jobUniqueID=").append(jobUniqueID);
			for (JobProvenanceValueSummary jpvs : jpvsMap.values()) {
				sb.append("\n\t").append(jpvs);
			}
			sb.append(']');

			return sb.toString();
		}

	}// ;

}
